/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.Cache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.TLB;
import org.xml.sax.Attributes;

public class CPUInfo {
    private String vendor;
    private String brand;
    private String cpuidInfo;
    private int revision;
    private float clockspeed;
    private int cacheLevels;
    private List<List<Cache>> cacheList = new ArrayList<List<Cache>>();
    private List<List<TLB>> tlbList = new ArrayList<List<TLB>>();
    private static final String VENDORTAG = "vendor";
    private static final String BRANDTAG = "brand";
    private static final String CPUIDINFOTAG = "cpuidinfo";
    private static final String REVISIONTAG = "revision";
    private static final String CLOCKSPEEDTAG = "clockspeed";
    private static final String CACHEINFOTAG = "cacheinfo";
    private static final String CACHETAG = "cache";
    private static final String TYPEATT = "type";
    private static final String LEVELSTAG = "levels";
    private static final String TLBINFOTAG = "tlbinfo";
    private static final String TLBTAG = "tlb";
    private static final Set<String> keySet = new TreeSet<String>();
    private String tmpValue = "";
    private String tmpElementName;
    private boolean inTLBParsing;
    private Cache tmpCache;
    private TLB tmpTLB;

    static {
        keySet.add(VENDORTAG);
        keySet.add(BRANDTAG);
        keySet.add(CPUIDINFOTAG);
        keySet.add(REVISIONTAG);
        keySet.add(CLOCKSPEEDTAG);
        keySet.add(LEVELSTAG);
        keySet.add(TLBTAG);
        keySet.add(CACHEINFOTAG);
        keySet.add(TLBINFOTAG);
    }

    CPUInfo() {
        this.tlbList.add(new ArrayList());
        this.inTLBParsing = false;
    }

    static boolean containsKey(String str) {
        return keySet.contains(str) || Cache.containsKey(str) || TLB.containsKey(str);
    }

    void startElement(String uri, String localName, String qName, Attributes atts) {
        this.tmpElementName = qName;
        if (qName.equals(CACHETAG)) {
            this.tmpCache = Cache.newInstance(atts.getValue(TYPEATT));
        } else if (qName.equals(TLBTAG)) {
            this.tmpTLB = TLB.newInstance(atts.getValue(TYPEATT));
            this.inTLBParsing = true;
        }
        if (Cache.containsKey(qName) && !this.inTLBParsing) {
            this.tmpCache.startElement(uri, localName, qName, atts);
        } else if (TLB.containsKey(qName)) {
            this.tmpTLB.startElement(uri, localName, qName, atts);
        }
        this.tmpValue = "";
    }

    void characters(char[] ch, int start, int length) {
        if (Cache.containsKey(this.tmpElementName) && !this.inTLBParsing) {
            this.tmpCache.characters(ch, start, length);
        } else if (TLB.containsKey(this.tmpElementName)) {
            this.tmpTLB.characters(ch, start, length);
        } else {
            String tmpString = new String(ch, start, length);
            if (tmpString.length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (Cache.containsKey(qName) && !this.inTLBParsing) {
            this.tmpCache.endElement(uri, localName, qName);
        } else if (TLB.containsKey(qName)) {
            this.tmpTLB.endElement(uri, localName, qName);
        } else if (qName.equals(VENDORTAG)) {
            this.vendor = this.tmpValue;
        } else if (qName.equals(BRANDTAG)) {
            this.brand = this.tmpValue;
        } else if (qName.equals(CPUIDINFOTAG)) {
            this.cpuidInfo = this.tmpValue;
        } else if (qName.equals(REVISIONTAG)) {
            this.revision = Integer.parseInt(this.tmpValue);
        } else if (qName.equals(CLOCKSPEEDTAG)) {
            this.clockspeed = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(LEVELSTAG)) {
            this.cacheLevels = Integer.parseInt(this.tmpValue);
            if (this.cacheLevels < 1) {
                throw new RuntimeException("Error: cache level is " + this.cacheLevels + ", it should be >= 1.");
            }
        }
        if (qName.equals(CACHETAG)) {
            if (this.tmpCache == null) {
                throw new RuntimeException("Error: in parsing \"cache\" tag, tmpCache is null.");
            }
            int tmpLevel = this.tmpCache.getLevel();
            if (tmpLevel > this.cacheList.size()) {
                int i = this.cacheList.size();
                while (i < tmpLevel - 1) {
                    this.cacheList.add(null);
                    ++i;
                }
                this.cacheList.add(new ArrayList());
            } else if (this.cacheList.get(tmpLevel - 1) == null) {
                this.cacheList.set(tmpLevel - 1, new ArrayList());
            }
            this.cacheList.get(tmpLevel - 1).add(this.tmpCache);
        } else if (qName.equals(TLBTAG)) {
            if (this.tmpTLB == null) {
                throw new RuntimeException("Error: in parsing \"TLB\" tag, tmpTLB is null.");
            }
            int tmpLevel = this.tmpTLB.getLevel();
            if (tmpLevel < 1) {
                throw new RuntimeException("Error: tlb level is " + tmpLevel + ", it should be >=1.");
            }
            if (tmpLevel > this.tlbList.size()) {
                int i = this.tlbList.size();
                while (i < tmpLevel - 1) {
                    this.tlbList.add(null);
                    ++i;
                }
                this.tlbList.add(new ArrayList());
            } else if (this.tlbList.get(tmpLevel - 1) == null) {
                this.tlbList.set(tmpLevel - 1, new ArrayList());
            }
            this.tlbList.get(tmpLevel - 1).add(this.tmpTLB);
        }
        this.tmpValue = "";
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("CPU Information:\n").append("  [Vendor:     ").append(this.vendor).append("]\n");
        if (this.brand != null) {
            res.append("  [Brand:      ").append(this.brand).append("]\n");
        }
        if (this.cpuidInfo != null) {
            res.append("  [CPUID info:      ").append(this.cpuidInfo).append("]\n");
        }
        res.append("  [Revision:   ").append(this.revision).append("]\n").append("  [Clockspeed: ").append(this.clockspeed).append(" (MHz)]\n").append("  [Cache Levels: ").append(this.cacheLevels).append("]\n");
        int i = 0;
        while (i < this.cacheList.size()) {
            if (this.cacheList.get(i) != null && this.cacheList.get(i).size() > 0) {
                res.append("    Level ").append(i + 1).append(":\n");
                for (Cache tmpc : this.cacheList.get(i)) {
                    res.append("  ").append(tmpc);
                }
            }
            ++i;
        }
        res.append("  [TLB Info]\n");
        i = 0;
        while (i < this.tlbList.size()) {
            if (this.tlbList.get(i) != null && this.tlbList.get(i).size() > 0) {
                res.append("    Level ").append(i + 1).append(":\n");
                for (TLB tmpt : this.tlbList.get(i)) {
                    res.append("  ").append(tmpt);
                }
            }
            ++i;
        }
        return res.toString();
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getCPUIDInfo() {
        return this.cpuidInfo;
    }

    public int getRevision() {
        return this.revision;
    }

    public float getClockSpeed() {
        return this.clockspeed;
    }

    public int getCacheLevels() {
        return this.cacheLevels;
    }

    public List<List<Cache>> getCaches() {
        return this.cacheList;
    }

    public List<List<TLB>> getTLBs() {
        return this.tlbList;
    }

    public int getTotalCacheSizeOfLevel(int level) {
        if (level < 1 || level > this.cacheList.size()) {
            return 0;
        }
        int size = 0;
        for (Cache cache : this.cacheList.get(level - 1)) {
            if (!cache.getSizeUnits().equals("KB")) continue;
            size += cache.getSize();
        }
        return size;
    }
}

