/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.Map;
import java.util.TreeMap;

public class PS_Module {
    private final String file;
    private final String offset;
    Map<Long, Long> sampleMap;

    PS_Module(String file, String offset) {
        this.file = file;
        this.offset = offset;
        this.sampleMap = new TreeMap<Long, Long>();
    }

    void addSample(Long pc, long count) {
        this.sampleMap.put(pc, count);
    }

    public String getFile() {
        return this.file;
    }

    public String getOffset() {
        return this.offset;
    }

    public Map<Long, Long> getSampleMap() {
        return this.sampleMap;
    }

    public long getNumSamples() {
        long sum = 0L;
        for (Map.Entry<Long, Long> pairs : this.sampleMap.entrySet()) {
            sum += pairs.getValue().longValue();
        }
        return sum;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("  [file: " + this.file + ", offset: " + this.offset + "]\n");
        for (Map.Entry<Long, Long> entry : this.sampleMap.entrySet()) {
            res.append("    [").append(entry.getKey().toString()).append(" = ").append(entry.getValue().toString()).append("]\n");
        }
        return res.toString();
    }
}

