/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.internal.rm.lml.core.model.UsageAdapter;
import org.eclipse.ptp.internal.rm.lml.core.model.UsagebarInterpreter;
import org.eclipse.ptp.rm.lml.core.elements.JobType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.elements.UsageType;
import org.eclipse.ptp.rm.lml.core.elements.UsagebarType;
import org.eclipse.ptp.rm.lml.core.elements.UsagebarlayoutType;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IUsagebarInterpreter;
import org.eclipse.ptp.rm.lml.core.model.OIDToObject;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.ui.providers.support.ColorConversion;
import org.eclipse.ptp.rm.lml.ui.providers.support.Scale;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class UsagebarPainter
implements PaintListener {
    private final UsageAdapter usageAdapter;
    private final UsagebarlayoutType layout;
    private List<JobInterval> jobIntervals;
    private final List<JobType> jobs;
    private int standardFrame;
    private int mouseOverFrame;
    private final Scale scale;
    private double barFactor = 0.6;
    private double lineFactor = 0.2;
    private static final int minTickmarks = 10;
    private static final int tickMarkMultipleOf = 10;
    private Rectangle paintArea;
    private final ILguiItem lguiItem;
    private final IUsagebarInterpreter usagebarInterpreter;
    private Composite usagebarComp;
    private boolean paintScale;

    public static int ceilDiv(int a, int b) {
        if (a % b == 0) {
            return a / b;
        }
        return a / b + 1;
    }

    public UsagebarPainter(ILguiItem lguiItem, UsageAdapter usageAdapter, Composite usagebarComp) {
        this(lguiItem, usageAdapter, new Rectangle(0, 0, usagebarComp.getSize().x, usagebarComp.getSize().y));
        this.usagebarComp = usagebarComp;
    }

    public UsagebarPainter(ILguiItem lguiItem, UsageAdapter usageAdapter, Rectangle paintArea) {
        this.lguiItem = lguiItem;
        this.usageAdapter = usageAdapter;
        this.paintArea = paintArea;
        this.layout = lguiItem.getLayoutAccess().getUsagebarLayout(usageAdapter.getId());
        this.usagebarInterpreter = new UsagebarInterpreter(usageAdapter);
        this.standardFrame = 1;
        this.mouseOverFrame = 3;
        this.scale = new Scale(0.0, 0.0, this.layout.getInterval().intValue());
        this.setShowModus(!usageAdapter.isUsageType() && this.layout.getScale().equals("nodes"));
        this.paintScale = true;
        this.jobs = usageAdapter.getJob();
        UsagebarInterpreter.JobComparator comp = new UsagebarInterpreter.JobComparator();
        Collections.sort(this.jobs, comp);
    }

    public UsagebarPainter(ILguiItem lguiItem, UsagebarType usagebar, Composite usagebarComp) {
        this(lguiItem, new UsageAdapter(usagebar), usagebarComp);
    }

    public UsagebarPainter(ILguiItem lguiItem, UsagebarType usagebar, Rectangle paintArea) {
        this(lguiItem, new UsageAdapter(usagebar), paintArea);
    }

    public UsagebarPainter(ILguiItem lguiItem, UsageType usage, Composite usagebarComp) {
        this(lguiItem, new UsageAdapter(usage), usagebarComp);
    }

    public UsagebarPainter(ILguiItem lguiItem, UsageType usage, Rectangle paintArea) {
        this(lguiItem, new UsageAdapter(usage), paintArea);
    }

    public void detectJobPositions() {
        if (this.usagebarComp != null) {
            this.updatePaintArea(new Rectangle(0, 0, this.usagebarComp.getSize().x, this.usagebarComp.getSize().y));
        }
        this.jobIntervals = new ArrayList<JobInterval>();
        int cpuSum = 0;
        for (JobType job : this.jobs) {
            JobInterval jobInt = this.getCurrentJobInterval(job, cpuSum);
            int currentCPUs = job.getCpucount().intValue();
            cpuSum += currentCPUs;
            this.jobIntervals.add(jobInt);
        }
    }

    public ObjectType getJobAtPosition(int x) {
        if (this.jobIntervals == null) {
            return null;
        }
        for (JobInterval jobInterval : this.jobIntervals) {
            if (x < jobInterval.start || x > jobInterval.end) continue;
            return jobInterval.job;
        }
        return null;
    }

    public List<JobInterval> getJobIntervals() {
        return this.jobIntervals;
    }

    public int getMouseOverFrame() {
        return this.mouseOverFrame;
    }

    public Scale getScale() {
        return this.scale;
    }

    public int getStandardFrame() {
        return this.standardFrame;
    }

    public boolean isPaintingScale() {
        return this.paintScale;
    }

    public boolean isShowingNodescale() {
        return this.scale.isShowingNodescale();
    }

    public void paintControl(PaintEvent event) {
        if (this.usagebarComp != null) {
            this.updatePaintArea(new Rectangle(0, 0, this.usagebarComp.getSize().x, this.usagebarComp.getSize().y));
        }
        GC gc = event.gc;
        OIDToObject oidToObject = this.lguiItem.getOIDToObject();
        ObjectStatus objectStatus = this.lguiItem.getObjectStatus();
        int width = this.paintArea.width;
        int barHeight = (int)((double)this.paintArea.height * this.barFactor);
        this.jobIntervals = new ArrayList<JobInterval>();
        int allCPU = this.usageAdapter.getCpuCount().intValue();
        int cpuSum = 0;
        for (JobType job : this.jobs) {
            JobInterval jobInt = this.getCurrentJobInterval(job, cpuSum);
            int currentCPUs = job.getCpucount().intValue();
            cpuSum += currentCPUs;
            Color jobColor = ColorConversion.getColor(oidToObject.getColorById(job.getOid()));
            ObjectType jobObject = jobInt.job;
            if (!objectStatus.isMouseDown(jobObject) && objectStatus.isAnyMouseDown()) {
                jobColor = ColorConversion.getColor(oidToObject.getColorById(null));
            }
            gc.setBackground(event.display.getSystemColor(2));
            gc.fillRectangle(jobInt.start, this.paintArea.y, jobInt.outerWidth, barHeight);
            gc.setBackground(jobColor);
            gc.fillRectangle(jobInt.start + jobInt.frame, jobInt.frame + this.paintArea.y, jobInt.outerWidth - 2 * jobInt.frame, barHeight - 2 * jobInt.frame);
            this.jobIntervals.add(jobInt);
        }
        if (cpuSum < allCPU) {
            int x = cpuSum * width / allCPU;
            gc.setBackground(event.display.getSystemColor(2));
            gc.fillRectangle(x + this.paintArea.x, 0 + this.paintArea.y, width - x, barHeight);
            Color jobColor = ColorConversion.getColor(oidToObject.getColorById("empty"));
            if (!objectStatus.isMouseDown(oidToObject.getObjectById("empty")) && objectStatus.isAnyMouseDown()) {
                jobColor = ColorConversion.getColor(oidToObject.getColorById(null));
            }
            gc.setBackground(jobColor);
            gc.fillRectangle(x + this.standardFrame + this.paintArea.x, this.standardFrame + this.paintArea.y, width - x - 2 * this.standardFrame, barHeight - 2 * this.standardFrame);
        }
        if (this.paintScale) {
            int scaleHeight = this.paintArea.height - barHeight;
            this.scale.paint(gc, this.paintArea.x, barHeight + this.paintArea.y, width, scaleHeight, this.lineFactor);
        }
    }

    public void setBarFactor(double factor) {
        if (factor >= 0.0 && factor <= 1.0) {
            this.barFactor = factor;
        }
    }

    public void setLineFactor(double factor) {
        if (factor >= 0.0 && factor <= 1.0) {
            this.lineFactor = factor;
        }
    }

    public void setMouseOverFrame(int mouseFrame) {
        this.mouseOverFrame = mouseFrame;
    }

    public void setPaintScale(boolean paintScale) {
        this.paintScale = paintScale;
    }

    public void setShowModus(boolean showNodes) {
        this.scale.setInterval(this.layout.getInterval().intValue());
        this.scale.setMax(showNodes ? this.usagebarInterpreter.getNodeCount() : this.usageAdapter.getCpuCount().intValue());
        if (showNodes) {
            this.scale.setUsagebarInterpreter(this.usagebarInterpreter);
        } else {
            this.scale.setUsagebarInterpreter(null);
        }
        this.adjustScale();
    }

    public void setStandardFrame(int standardFrame) {
        this.standardFrame = standardFrame;
    }

    public void updatePaintArea(Rectangle paintArea) {
        this.paintArea = paintArea;
    }

    protected void adjustScale() {
        if (!this.usageAdapter.isUsageType()) {
            return;
        }
        double max = this.scale.getMax();
        double min = 0.0;
        int interval = (int)((max - 0.0) / 10.0);
        if ((interval -= interval % 10) <= 0) {
            interval = (int)((max - 0.0) / 5.0);
            if ((interval -= interval % 10) <= 0) {
                interval = 1;
            }
        }
        this.scale.setInterval(interval);
    }

    protected JobInterval getCurrentJobInterval(JobType job, int cpuSum) {
        int x;
        int width = this.paintArea.width;
        int allCPU = this.usageAdapter.getCpuCount().intValue();
        OIDToObject oidToObject = this.lguiItem.getOIDToObject();
        ObjectType jobObject = oidToObject.getObjectById(job.getOid());
        int barHeight = (int)((double)this.paintArea.height * this.barFactor);
        int currentCPUs = job.getCpucount().intValue();
        int outerWidth = (cpuSum + currentCPUs) * width / allCPU - (x = cpuSum * width / allCPU) + 1;
        if (outerWidth + x >= width) {
            --outerWidth;
        }
        int frame = this.standardFrame;
        if (this.lguiItem.getObjectStatus().isMouseOver(jobObject)) {
            frame = this.mouseOverFrame;
        }
        if (outerWidth - 2 * frame < 0) {
            frame = 1;
        }
        if (barHeight - 2 * frame < 0) {
            frame = 1;
        }
        int innerWidth = outerWidth - 2 * frame;
        int end = (cpuSum + currentCPUs) * width / allCPU - 1;
        return new JobInterval(jobObject, x + this.paintArea.x, end + this.paintArea.x, innerWidth, outerWidth, frame);
    }

    public static class JobInterval {
        public int start;
        public int end;
        public int innerWidth;
        public int outerWidth;
        public int frame;
        public ObjectType job;

        public JobInterval(ObjectType job, int start, int end, int innerWidth, int outerWidth, int frame) {
            this.job = job;
            this.start = start;
            this.end = end;
            this.innerWidth = innerWidth;
            this.outerWidth = outerWidth;
            this.frame = frame;
        }
    }
}

