/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rse.core.ISystemResourceListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceHelpers;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;

public class SystemResourceManager {
    private static IProject remoteSystemsProject = null;
    private static IProject remoteSystemsTempFilesProject = null;
    private static SystemResourceHelpers helpers = null;
    private static ISystemResourceListener _listener = null;

    public static void turnOffResourceEventListening() {
        if (_listener != null) {
            _listener.turnOffResourceEventListening();
        }
    }

    public static void turnOnResourceEventListening() {
        if (_listener != null) {
            _listener.turnOnResourceEventListening();
        }
    }

    public static void ensureOnResourceEventListening() {
        if (_listener != null) {
            _listener.ensureOnResourceEventListening();
        }
    }

    public static void startResourceEventListening(ISystemResourceListener listener) {
        _listener = listener;
        listener.turnOnResourceEventListening();
        IWorkspace ws = remoteSystemsProject.getWorkspace();
        int eventMask = 1;
        ws.addResourceChangeListener((IResourceChangeListener)listener, eventMask);
    }

    public static void endResourceEventListening() {
        if (_listener != null) {
            IWorkspace ws = remoteSystemsProject.getWorkspace();
            ws.removeResourceChangeListener((IResourceChangeListener)_listener);
            _listener = null;
        }
    }

    public static void addResourceChangeListener(IResourceChangeListener l) {
        if (_listener != null) {
            _listener.addResourceChangeListener(l);
        }
    }

    public static void removeResourceChangeListener(IResourceChangeListener l) {
        if (_listener != null) {
            _listener.removeResourceChangeListener(l);
        }
    }

    public static IProject getRemoteSystemsProject(boolean force) {
        if (remoteSystemsProject == null) {
            remoteSystemsProject = ResourcesPlugin.getWorkspace().getRoot().getProject("RemoteSystemsConnections");
        }
        if (!remoteSystemsProject.exists() && force || remoteSystemsProject.exists() && !remoteSystemsProject.isOpen()) {
            SystemResourceManager.ensureRemoteSystemsProject(remoteSystemsProject);
        }
        return remoteSystemsProject;
    }

    public static IProject getRemoteSystemsTempFilesProject() {
        if (remoteSystemsTempFilesProject == null) {
            remoteSystemsTempFilesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("RemoteSystemsTempFiles");
        }
        return remoteSystemsTempFilesProject;
    }

    private static IProject ensureRemoteSystemsProject(IProject proj) {
        if (!proj.isOpen()) {
            try {
                proj.open(null);
            }
            catch (Exception e) {
                try {
                    proj.delete(false, true, null);
                    RSECorePlugin.getDefault().getLogger().logWarning("Removed stale remote systems project reference. Re-creating remote system project to recover.");
                }
                catch (CoreException exc) {
                    RSECorePlugin.getDefault().getLogger().logError("error opening remote systems project", e);
                }
            }
        }
        if (!proj.exists()) {
            try {
                proj.create(null);
                proj.open(null);
                IProjectDescription description = proj.getDescription();
                String[] newNatures = new String[]{"org.eclipse.rse.ui.remotesystemsnature"};
                description.setNatureIds(newNatures);
                proj.setDescription(description, null);
            }
            catch (Exception e) {
                RSECorePlugin.getDefault().getLogger().logError("error creating remote systems project", e);
            }
        }
        return proj;
    }

    public static void renameFolder(IFolder folder, String newName) {
        SystemResourceManager.getResourceHelpers().renameResource((IResource)folder, newName);
    }

    public static void deleteFolder(IFolder folder) {
        SystemResourceManager.getResourceHelpers().deleteResource((IResource)folder);
    }

    public static void renameFile(IFolder folder, String oldName, String newName) {
        SystemResourceManager.getResourceHelpers().renameResource((IResource)SystemResourceManager.getResourceHelpers().getFile((IContainer)folder, oldName), newName);
    }

    public static void deleteFile(IFolder folder, String fileName) {
        SystemResourceManager.getResourceHelpers().deleteResource((IResource)SystemResourceManager.getResourceHelpers().getFile((IContainer)folder, fileName));
    }

    public static String getProfileName(ISystemHostPool pool) {
        return pool.getName();
    }

    public static String getProfileName(ISystemFilterPoolManager mgr) {
        return mgr.getName();
    }

    public static String getFolderName(ISystemFilterPool pool) {
        return pool.getName();
    }

    public static String getFolderName(IHost conn) {
        return conn.getAliasName();
    }

    public static String getFolderName(ISubSystemConfiguration ssFactory) {
        return ssFactory.getId();
    }

    public static String getFolderPath(IFolder folder) {
        return SystemResourceManager.getResourceHelpers().getFolderPath(folder);
    }

    public static String getFolderPathWithTerminator(IFolder folder) {
        return SystemResourceManager.addPathTerminator(SystemResourceManager.getResourceHelpers().getFolderPath(folder));
    }

    protected static SystemResourceHelpers getResourceHelpers() {
        if (helpers == null) {
            helpers = SystemResourceHelpers.getResourceHelpers();
        }
        return helpers;
    }

    public static String addPathTerminator(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return path;
    }

    public static boolean testIfResourceInUse(IResource resource) {
        return SystemResourceHelpers.testIfResourceInUse(resource);
    }
}

