/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CustomFormToolkit
extends PlatformObject {
    private final FormToolkit toolkit;

    public CustomFormToolkit(FormToolkit toolkit) {
        Assert.isNotNull((Object)toolkit);
        this.toolkit = toolkit;
    }

    public final FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    public void dispose() {
    }

    public Object getAdapter(Class adapter) {
        if (FormToolkit.class.isAssignableFrom(adapter)) {
            return this.getFormToolkit();
        }
        return super.getAdapter(adapter);
    }

    protected int convertHeightInCharsToPixels(Control control, int chars) {
        int height = 0;
        if (control != null && !control.isDisposed()) {
            GC gc = new GC((Drawable)control);
            gc.setFont(JFaceResources.getDialogFont());
            height = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)chars);
            gc.dispose();
        }
        return height;
    }

    public ScrolledForm createScrolledForm(Composite parent, String title, boolean overwriteBackground) {
        Assert.isNotNull((Object)parent);
        ScrolledForm scrollableForm = this.getFormToolkit().createScrolledForm(parent);
        if (overwriteBackground) {
            scrollableForm.setBackground(parent.getBackground());
            scrollableForm.setBackgroundImage(parent.getBackgroundImage());
        }
        if (title != null && scrollableForm.getForm() != null) {
            scrollableForm.getForm().setText(title);
            this.getFormToolkit().decorateFormHeading(scrollableForm.getForm());
        }
        return scrollableForm;
    }

    public final ExpandableComposite createExpandableComposite(final ScrolledForm scrolledForm, String title, final int entriesToShow, boolean expanded, boolean overwriteBackground) {
        Assert.isNotNull((Object)scrolledForm);
        Assert.isNotNull((Object)title);
        Assert.isTrue((entriesToShow > 0 ? 1 : 0) != 0);
        final ExpandableComposite expandable = this.getFormToolkit().createExpandableComposite(scrolledForm.getBody(), 18);
        expandable.setText(title);
        if (overwriteBackground) {
            expandable.setBackground(scrolledForm.getBackground());
            expandable.setBackgroundImage(scrolledForm.getBackgroundImage());
        }
        expandable.setLayout((Layout)new GridLayout());
        expandable.setLayoutData((Object)new GridData(768));
        expandable.addExpansionListener(new IExpansionListener(){
            boolean notExpanded = true;

            public void expansionStateChanged(ExpansionEvent e) {
                scrolledForm.reflow(true);
                Shell shell = scrolledForm.getShell();
                if (shell != null && !shell.isDisposed() && e.getState() && this.notExpanded) {
                    shell.setRedraw(false);
                    Rectangle shellBounds = shell.getBounds();
                    shellBounds.height += CustomFormToolkit.this.convertHeightInCharsToPixels((Control)expandable, Math.max(4, entriesToShow)) + 4;
                    shell.setBounds(shellBounds);
                    shell.setRedraw(true);
                    this.notExpanded = false;
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite client = this.getFormToolkit().createComposite((Composite)expandable);
        client.setLayout((Layout)new GridLayout());
        if (overwriteBackground) {
            client.setBackground(scrolledForm.getBackground());
            client.setBackgroundImage(scrolledForm.getBackgroundImage());
        }
        expandable.setExpanded(expanded);
        expandable.setClient((Control)client);
        return expandable;
    }

    public final Section createSection(final ScrolledForm scrolledForm, String title, final int entriesToShow, boolean expanded, boolean overwriteBackground) {
        Assert.isNotNull((Object)scrolledForm);
        Assert.isNotNull((Object)title);
        Assert.isTrue((entriesToShow > 0 ? 1 : 0) != 0);
        final Section section = this.getFormToolkit().createSection(scrolledForm.getBody(), 274);
        section.setText(title);
        if (overwriteBackground) {
            section.setBackground(scrolledForm.getBackground());
            section.setBackgroundImage(scrolledForm.getBackgroundImage());
        }
        section.setLayout((Layout)new GridLayout());
        if (scrolledForm.getBody().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        section.addExpansionListener(new IExpansionListener(){
            boolean notExpanded = true;

            public void expansionStateChanged(ExpansionEvent e) {
                scrolledForm.reflow(true);
                Shell shell = scrolledForm.getShell();
                if (shell != null && !shell.isDisposed() && e.getState() && this.notExpanded) {
                    shell.setRedraw(false);
                    Rectangle shellBounds = shell.getBounds();
                    shellBounds.height += CustomFormToolkit.this.convertHeightInCharsToPixels((Control)section, Math.max(4, entriesToShow)) + 4;
                    shell.setBounds(shellBounds);
                    shell.setRedraw(true);
                    this.notExpanded = false;
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite client = this.getFormToolkit().createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        if (overwriteBackground) {
            client.setBackground(scrolledForm.getBackground());
            client.setBackgroundImage(scrolledForm.getBackgroundImage());
        }
        section.setExpanded(expanded);
        section.setClient((Control)client);
        return section;
    }

    public final Section createSection(ScrolledForm scrolledForm, String title, boolean overwriteBackground) {
        Assert.isNotNull((Object)scrolledForm);
        Assert.isNotNull((Object)title);
        Section section = this.getFormToolkit().createSection(scrolledForm.getBody(), 272);
        section.setText(title);
        if (overwriteBackground) {
            section.setBackground(scrolledForm.getBackground());
            section.setBackgroundImage(scrolledForm.getBackgroundImage());
        }
        section.setLayout((Layout)new GridLayout());
        if (scrolledForm.getBody().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        Composite client = this.getFormToolkit().createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        if (overwriteBackground) {
            client.setBackground(section.getBackground());
            client.setBackgroundImage(section.getBackgroundImage());
        }
        section.setClient((Control)client);
        return section;
    }

    public final Section createSection(Composite parent, String title, boolean overwriteBackground) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)title);
        Section section = this.getFormToolkit().createSection(parent, 272);
        section.setText(title);
        if (overwriteBackground) {
            section.setBackground(parent.getBackground());
            section.setBackgroundImage(parent.getBackgroundImage());
        }
        section.setLayout((Layout)new GridLayout());
        if (parent.getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        Composite client = this.getFormToolkit().createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        if (overwriteBackground) {
            client.setBackground(section.getBackground());
            client.setBackgroundImage(section.getBackgroundImage());
        }
        section.setClient((Control)client);
        return section;
    }

    public final Composite createNoteComposite(Composite parent, String title, String message, int widthHint, boolean overwriteBackground) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)message);
        Composite composite = this.getFormToolkit().createComposite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(256));
        composite.setFont(parent.getFont());
        Label noteLabel = this.getFormToolkit().createLabel(composite, title, 1);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        Label messageLabel = this.getFormToolkit().createLabel(composite, message);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = widthHint;
        messageLabel.setLayoutData((Object)layoutData);
        messageLabel.setFont(parent.getFont());
        if (overwriteBackground) {
            composite.setBackground(parent.getBackground());
            composite.setBackgroundImage(parent.getBackgroundImage());
            noteLabel.setBackground(parent.getBackground());
            noteLabel.setBackgroundImage(parent.getBackgroundImage());
            messageLabel.setBackground(parent.getBackground());
            messageLabel.setBackgroundImage(parent.getBackgroundImage());
        }
        return composite;
    }
}

