/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.OperatorPrecedence;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class LocalUniqueVariableSupport
extends LocalVariableSupport {
    private static final String BASE = "variable.localUnique.";
    public static final String P_DECLARE_FINAL = "variable.localUnique.final";

    public LocalUniqueVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public LocalUniqueVariableSupport(JavaInfo javaInfo, SimpleName variable) {
        super(javaInfo, variable);
    }

    public String toString() {
        return "local-unique: " + this.getName();
    }

    public void setName(String newName) throws Exception {
        this.modifyName(newName);
    }

    public String getReferenceExpression(NodeTarget target) throws Exception {
        this.assertJavaInfoCreatedAt(target);
        if (this.isVisibleAtTarget(target)) {
            return this.getName();
        }
        this.convertLocalToField();
        return this.m_javaInfo.getVariableSupport().getReferenceExpression(target);
    }

    public void convertLocalToField() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        String fieldName = this.addUniqueField(this.isStaticContext(), this.m_declaration);
        this.setName(fieldName);
        VariableDeclaration declaration = this.m_declaration;
        if (declaration.getInitializer() != null) {
            this.replaceDeclarationWithAssignment(editor, declaration);
        } else {
            editor.removeStatement((Statement)declaration.getParent());
        }
        this.m_javaInfo.setVariableSupport(new FieldUniqueVariableSupport(this.m_javaInfo, this.m_variable));
    }

    public String add_getVariableStatementSource(StatementTarget associationTarget) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        String className = this.m_javaInfo.getDescription().getComponentClass().getName();
        NodeTarget creationTarget = new NodeTarget(associationTarget);
        String initializer = this.m_javaInfo.getCreationSupport().add_getSource(creationTarget);
        String variableName = editor.getUniqueVariableName(associationTarget.getPosition(), NamesManager.getName(this.m_javaInfo), null);
        initializer = StringUtils.replace((String)initializer, (String)"%variable-name%", (String)variableName);
        String modifiers = this.prefDeclareFinal() ? "final " : "";
        return String.valueOf(modifiers) + className + " " + variableName + " = " + initializer + ";";
    }

    public void add_setVariableStatement(Statement statement) throws Exception {
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
        VariableDeclaration fragment = (VariableDeclaration)variableDeclarationStatement.fragments().get(0);
        this.add_setVariableAndInitializer((Expression)fragment.getName(), fragment.getInitializer());
    }

    public void deleteBefore() throws Exception {
        Expression initializer = this.m_declaration.getInitializer();
        this.m_javaInfo.getRelatedNodes().remove(initializer);
    }

    public void deleteAfter() throws Exception {
        if (this.m_javaInfo.isRoot()) {
            return;
        }
        this.m_javaInfo.getEditor().removeVariableDeclaration(this.m_declaration);
    }

    public void setType(String newTypeName) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        editor.replaceVariableType(this.m_declaration, newTypeName);
    }

    public boolean canInline() {
        ArrayList references = Lists.newArrayList(this.getReferences());
        references.remove(this.m_variable);
        return references.size() == 1;
    }

    public void inline() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        ArrayList references = Lists.newArrayList(this.getReferences());
        references.remove(this.m_variable);
        Preconditions.checkState((references.size() == 1 ? 1 : 0) != 0, (Object)references);
        Expression reference = (Expression)references.get(0);
        Expression initializer = this.m_declaration.getInitializer();
        AstEditor.replaceNode((ASTNode)initializer, (ASTNode)initializer.getAST().newSimpleName("__wbp_tmp"));
        this.replaceReferenceWithInitializer(reference, initializer);
        editor.removeStatement((Statement)this.getDeclarationStatement());
        this.m_javaInfo.setVariableSupport(new EmptyVariableSupport(this.m_javaInfo, initializer));
    }

    private void replaceReferenceWithInitializer(Expression reference, Expression initializer) throws Exception {
        int initializerPrecedence;
        Expression parent;
        int parentPrecedence;
        AstEditor editor = this.m_javaInfo.getEditor();
        if (reference.getParent() instanceof Expression && (parentPrecedence = OperatorPrecedence.getExpressionPrecedence(parent = (Expression)reference.getParent())) > (initializerPrecedence = OperatorPrecedence.getExpressionPrecedence(initializer))) {
            String parenthesizedSource = "(" + editor.getSource((ASTNode)initializer) + ")";
            editor.replaceSubstring(reference.getStartPosition(), reference.getLength(), parenthesizedSource);
            ParenthesizedExpression parenthesized = reference.getAST().newParenthesizedExpression();
            parenthesized.setExpression(initializer);
            parenthesized.setSourceRange(reference.getStartPosition(), 1 + initializer.getLength() + 1);
            AstEditor.replaceNode((ASTNode)reference, (ASTNode)parenthesized);
            AstNodeUtils.moveNode((ASTNode)initializer, 1 + parenthesized.getStartPosition());
            this.m_javaInfo.addRelatedNode((ASTNode)parenthesized);
            return;
        }
        editor.replaceSubstring(reference.getStartPosition(), reference.getLength(), editor.getSource((ASTNode)initializer));
        AstEditor.replaceNode((ASTNode)reference, (ASTNode)initializer);
        AstNodeUtils.moveNode((ASTNode)initializer, reference.getStartPosition());
    }

    private boolean prefDeclareFinal() {
        return this.getPreferences().getBoolean(P_DECLARE_FINAL);
    }
}

