/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.xml.model.utils.NamespacesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InnerClassPropertyEditor
extends TextDialogPropertyEditor
implements IConfigurablePropertyObject {
    private String m_baseName;
    private String m_className;
    private String m_source;
    private boolean m_disabled;

    protected String getText(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        String className = InnerClassPropertyEditor.getClassName(genericProperty);
        if (className != null) {
            return CodeUtils.getShortClass((String)className);
        }
        return "<double click>";
    }

    private static String getClassName(GenericProperty genericProperty) {
        DocumentElement objectElement = genericProperty.getObject().getElement();
        String attributeName = genericProperty.getTitle();
        DocumentElement propertyElement = objectElement.getChild(String.valueOf(objectElement.getTag()) + "." + attributeName, false);
        if (propertyElement == null) {
            return null;
        }
        DocumentElement classElement = propertyElement.getChildAt(0);
        String tag = classElement.getTag();
        int index = tag.indexOf(58);
        String packageNS = tag.substring(0, index);
        String shortClassName = tag.substring(index + 1);
        String uri = NamespacesHelper.getURI((DocumentElement)objectElement, (String)packageNS);
        String packageName = StringUtils.removeStart((String)uri, (String)"clr-namespace:");
        return String.valueOf(packageName) + "." + shortClassName;
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openClass(property);
        }
        return false;
    }

    protected void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        XmlObjectInfo object = genericProperty.getObject();
        IJavaProject javaProject = object.getContext().getJavaProject();
        IType type = JdtUiUtils.selectClassType((Shell)DesignerPlugin.getShell(), (IJavaProject)javaProject);
        if (type != null) {
            InnerClassPropertyEditor.setClassName(genericProperty, type.getFullyQualifiedName());
        }
    }

    public void doubleClick(Property property, Point location) throws Exception {
        this.openClass(property);
    }

    private void openClass(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        if (this.m_disabled) {
            return;
        }
        String className = InnerClassPropertyEditor.getClassName(genericProperty);
        if (className != null) {
            IJavaProject javaProject = genericProperty.getObject().getContext().getJavaProject();
            IType type = javaProject.findType(className);
            JavaUI.openInEditor((IJavaElement)type);
            return;
        }
        this.createNewClass(genericProperty);
        this.openClass(property);
    }

    private void createNewClass(GenericProperty genericProperty) throws Exception {
        XmlObjectInfo object = genericProperty.getObject();
        IPackageFragment packageFragment = InnerClassPropertyEditor.getPackageFragment(object);
        String packageName = packageFragment.getElementName();
        String newName = InnerClassPropertyEditor.generateUniqueTypeName(packageFragment, this.m_baseName);
        String source = this.m_source;
        source = this.updateSourceIfAnonymous(source);
        source = StringUtils.replace((String)source, (String)"${name}", (String)newName);
        source = StringUtils.replace((String)source, (String)"private class", (String)"public class");
        source = StringUtils.replace((String)source, (String)"private static class", (String)"public class");
        source = "package " + packageName + ";\r\n" + source;
        String unitName = String.valueOf(newName) + ".java";
        ICompilationUnit unit = packageFragment.createCompilationUnit(unitName, source, false, null);
        AstEditor astEditor = new AstEditor(unit);
        astEditor.resolveImports((ASTNode)DomGenerics.types((CompilationUnit)astEditor.getAstUnit()).get(0));
        astEditor.commitChanges();
        unit.save(null, false);
        ProjectUtils.waitForAutoBuild();
        String newClassName = String.valueOf(packageName) + "." + newName;
        InnerClassPropertyEditor.setClassName(genericProperty, newClassName);
    }

    private String updateSourceIfAnonymous(String source) {
        if (source.startsWith("new ")) {
            int superBegin = "new ".length();
            int superEnd = source.indexOf(40);
            int classOpen = source.indexOf(123);
            String superName = source.substring(superBegin, superEnd);
            source = "public class ${name} extends " + superName + " " + source.substring(classOpen);
        }
        return source;
    }

    private static void setClassName(GenericProperty genericProperty, String newClassName) {
        XmlObjectInfo object = genericProperty.getObject();
        String packageName = CodeUtils.getPackage((String)newClassName);
        String newName = CodeUtils.getShortClass((String)newClassName);
        DocumentElement objectElement = object.getElement();
        DocumentElement propertyElement = new DocumentElement();
        propertyElement.setTag(String.valueOf(objectElement.getTag()) + "." + genericProperty.getTitle());
        objectElement.addChild(propertyElement);
        String newClassTag = String.valueOf(InnerClassPropertyEditor.getPackageNamespace(object, packageName)) + ":" + newName;
        DocumentElement newClassElement = new DocumentElement();
        newClassElement.setTag(newClassTag);
        propertyElement.addChild(newClassElement);
        ExecutionUtils.refresh((ObjectInfo)object);
    }

    private static IPackageFragment getPackageFragment(XmlObjectInfo object) {
        IFolder parentFolder = (IFolder)object.getContext().getFile().getParent();
        return (IPackageFragment)JavaCore.create((IFolder)parentFolder);
    }

    private static String generateUniqueTypeName(IPackageFragment packageFragment, String baseName) {
        int index = 1;
        String name;
        while (packageFragment.getCompilationUnit(String.valueOf(name = String.valueOf(baseName) + "_" + index) + ".java").exists()) {
            ++index;
        }
        return name;
    }

    private static String getPackageNamespace(XmlObjectInfo object, String packageName) {
        DocumentElement element = object.getCreationSupport().getElement();
        return NamespacesHelper.ensureName((DocumentElement)element, (String)("clr-namespace:" + packageName), (String)"p");
    }

    public void configure(EditorContext context, Map<String, Object> parameters) throws Exception {
        this.m_baseName = (String)parameters.get("name");
        Assert.isNotNull((Object)this.m_baseName, (String)"'name' attribute required.");
        this.m_className = (String)parameters.get("class");
        Assert.isNotNull((Object)this.m_className, (String)"'class' attribute required.");
        this.m_source = (String)parameters.get("source");
        Assert.isNotNull((Object)this.m_source, (String)"'source' attribute required.");
        this.m_source = this.m_source.trim();
        this.m_disabled = "true".equals(parameters.get("disableInXML"));
    }
}

