/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NodeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PrimaryExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Step;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class Normalizer
implements XPathVisitor {
    private StaticContext _sc;

    public Normalizer(StaticContext sc) {
        this._sc = sc;
    }

    public Object visit(XPath xp) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        Iterator i = xp.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            Expr n = (Expr)e.accept(this);
            exprs.add(n);
        }
        return new XPath(exprs);
    }

    private void printVarExprPairs(Iterator i) {
        while (i.hasNext()) {
            VarExprPair pair = (VarExprPair)i.next();
            pair.varname();
            Expr e = pair.expr();
            e.accept(this);
        }
    }

    private void doForExpr(Iterator iter, Expr expr) {
        ArrayList<QName> vars = new ArrayList<QName>();
        while (iter.hasNext()) {
            VarExprPair pair = (VarExprPair)iter.next();
            QName var = pair.varname();
            Expr e = pair.expr();
            vars.add(var);
            e.accept(this);
        }
        Iterator i = vars.iterator();
        while (i.hasNext()) {
            QName cfr_ignored_0 = (QName)i.next();
        }
        expr.accept(this);
    }

    public Object visit(ForExpr fex) {
        ForExpr last = fex;
        Expr ret = fex.expr();
        int depth = 0;
        Iterator i = fex.iterator();
        while (i.hasNext()) {
            VarExprPair ve = (VarExprPair)i.next();
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                ForExpr fe = new ForExpr(pairs, ret);
                last.set_expr(fe);
                last = fe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            fex.truncate_pairs();
        }
        return fex;
    }

    public Object visit(QuantifiedExpr qex) {
        QuantifiedExpr last = qex;
        Expr ret = qex.expr();
        int depth = 0;
        Iterator i = qex.iterator();
        while (i.hasNext()) {
            VarExprPair ve = (VarExprPair)i.next();
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                QuantifiedExpr qe = new QuantifiedExpr(qex.type(), pairs, ret);
                last.set_expr(qe);
                last = qe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            qex.truncate_pairs();
        }
        return qex;
    }

    private void printExprs(Iterator i) {
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
    }

    public Object visit(IfExpr ifex) {
        this.printExprs(ifex.iterator());
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return ifex;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    private BinExpr make_logic_expr(BinExpr e) {
        Collection normalized = this.normalize_bin_args(e);
        XPathNode[] nor_arr = new XPathNode[2];
        int j = 0;
        Iterator i = normalized.iterator();
        while (i.hasNext()) {
            nor_arr[j] = (XPathNode)i.next();
            ++j;
        }
        ArrayList<XPathNode> args = new ArrayList<XPathNode>();
        args.add(nor_arr[0]);
        e.set_left(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        args.clear();
        args.add(nor_arr[1]);
        e.set_right(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        return e;
    }

    public Object visit(OrExpr orex) {
        return this.make_logic_expr(orex);
    }

    public Object visit(AndExpr andex) {
        return this.make_logic_expr(andex);
    }

    public Object visit(CmpExpr cmpex) {
        switch (cmpex.type()) {
            case 6: {
                return this.make_CmpOp(cmpex, new QName("fs", "eq", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 7: {
                return this.make_CmpOp(cmpex, new QName("fs", "ne", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 8: {
                return this.make_CmpOp(cmpex, new QName("fs", "lt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 10: {
                return this.make_CmpOp(cmpex, new QName("fs", "gt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 9: {
                return this.make_CmpOp(cmpex, new QName("fs", "le", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 11: {
                return this.make_CmpOp(cmpex, new QName("fs", "ge", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 12: {
                return this.make_function(new QName("op", "node-equal"), this.normalize_bin_args(cmpex));
            }
            case 13: {
                return this.make_function(new QName("op", "node-before"), this.normalize_bin_args(cmpex));
            }
            case 14: {
                return this.make_function(new QName("op", "node-after"), this.normalize_bin_args(cmpex));
            }
        }
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return cmpex;
    }

    private Collection normalize_bin_args(BinExpr e) {
        ArrayList<XPathNode> args = new ArrayList<XPathNode>();
        XPathNode left = (XPathNode)e.left().accept(this);
        XPathNode right = (XPathNode)e.right().accept(this);
        args.add(left);
        args.add(right);
        return args;
    }

    public Object visit(RangeExpr rex) {
        Collection args = this.normalize_bin_args(rex);
        return this.make_function(new QName("op", "to", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_xpathexpr(PrimaryExpr pex) {
        FilterExpr fe = new FilterExpr(pex, new ArrayList());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_int_lit(int i) {
        IntegerLiteral il = new IntegerLiteral(BigInteger.valueOf(i));
        return this.make_xpathexpr(il);
    }

    private XPathExpr make_string_lit(String s) {
        StringLiteral sl = new StringLiteral(s);
        return this.make_xpathexpr(sl);
    }

    private XPathExpr make_convert_operand(XPathExpr arg1, XPathExpr arg2) {
        ArrayList<XPathExpr> args = new ArrayList<XPathExpr>();
        args.add(arg1);
        args.add(arg2);
        return this.make_function(new QName("fs", "convert-operand", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_double_lit(double d) {
        DoubleLiteral dl = new DoubleLiteral(d);
        return this.make_xpathexpr(dl);
    }

    private XPathExpr make_convert_binop(BinExpr e, XPathExpr convarg, QName name) {
        Collection args = this.normalize_bin_args(e);
        XPathExpr[] args_arr = new XPathExpr[2];
        int j = 0;
        Iterator i = args.iterator();
        while (i.hasNext()) {
            args_arr[j] = (XPathExpr)i.next();
            ++j;
        }
        ArrayList<XPathExpr> argsfname = new ArrayList<XPathExpr>();
        j = 0;
        while (j < 2) {
            XPathExpr arg = this.make_convert_operand(args_arr[j], convarg);
            argsfname.add(arg);
            ++j;
        }
        return this.make_function(name, argsfname);
    }

    private XPathExpr make_ArithOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_double_lit(1.0), name);
    }

    private XPathExpr make_CmpOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_string_lit("string"), name);
    }

    public Object visit(AddExpr addex) {
        return this.make_ArithOp(addex, new QName("fs", "plus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(SubExpr subex) {
        return this.make_ArithOp(subex, new QName("fs", "minus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(MulExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "times", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(DivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "div", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(IDivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "idiv", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(ModExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "mod", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    public Object visit(UnionExpr unex) {
        Collection args = this.normalize_bin_args(unex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    public Object visit(PipeExpr pipex) {
        Collection args = this.normalize_bin_args(pipex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    public Object visit(IntersectExpr iexpr) {
        Collection args = this.normalize_bin_args(iexpr);
        return this.make_function(new QName("op", "intersect", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    public Object visit(ExceptExpr eexpr) {
        Collection args = this.normalize_bin_args(eexpr);
        return this.make_function(new QName("op", "except", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return ioexp;
    }

    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return taexp;
    }

    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return cexp;
    }

    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        return cexp;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    public Object visit(MinusExpr e) {
        SubExpr se = new SubExpr(this.make_int_lit(0), e.arg());
        return se.accept(this);
    }

    public Object visit(PlusExpr e) {
        AddExpr ae = new AddExpr(this.make_int_lit(0), e.arg());
        return ae.accept(this);
    }

    private XPathExpr make_function(QName name, Collection args) {
        FunctionCall fc = new FunctionCall(name, args);
        FilterExpr fe = new FilterExpr(fc, new ArrayList());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_root_self_node() {
        ForwardStep self_node = new ForwardStep(4, new AnyKindTest());
        AxisStep self_node_expr = new AxisStep(self_node, new ArrayList());
        XPathExpr self_node_xpath = new XPathExpr(0, self_node_expr);
        ArrayList<XPathExpr> args = new ArrayList<XPathExpr>();
        args.add(self_node_xpath);
        XPathExpr xpe = this.make_function(new QName("fn", "root", "http://www.w3.org/2005/xpath-functions"), args);
        return xpe;
    }

    private XPathExpr make_descendant_or_self() {
        ForwardStep desc_self_node = new ForwardStep(5, new AnyKindTest());
        AxisStep se = new AxisStep(desc_self_node, new ArrayList());
        return new XPathExpr(0, se);
    }

    public Object visit(XPathExpr e) {
        XPathExpr xp = e;
        int depth = 0;
        XPathExpr result = e;
        while (xp != null) {
            XPathExpr next;
            int slashes = xp.slashes();
            StepExpr se = xp.expr();
            if (slashes == 1) {
                if (se == null) {
                    return this.make_root_self_node();
                }
                if (depth == 0) {
                    XPathExpr xpe = this.make_root_self_node();
                    xpe.set_next(e);
                    result = xpe;
                }
            }
            if (slashes == 2 && depth == 0) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                e.set_slashes(1);
                desc.set_next(e);
                XPathExpr root_self = this.make_root_self_node();
                root_self.set_next(desc);
                return root_self;
            }
            if (se != null) {
                se.accept(this);
            }
            if ((next = xp.next()) != null && next.slashes() == 2) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                xp.set_next(desc);
                desc.set_next(next);
                next.set_slashes(1);
            }
            xp = next;
            ++depth;
        }
        return result;
    }

    public Object visit(ForwardStep e) {
        int axis = e.axis();
        switch (axis) {
            case 9: {
                e.set_axis(3);
                break;
            }
            case 0: {
                e.set_axis(1);
            }
        }
        e.node_test().accept(this);
        return e;
    }

    public Object visit(ReverseStep e) {
        if (e.axis() == 5) {
            AnyKindTest nt = new AnyKindTest();
            ReverseStep s = new ReverseStep(0, nt);
            return s;
        }
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        return e;
    }

    public Object visit(NameTest e) {
        String prefix = e.name().prefix();
        if (prefix == null) {
            return null;
        }
        return e;
    }

    public Object visit(VarRef e) {
        return e;
    }

    public Object visit(StringLiteral e) {
        return e;
    }

    public Object visit(IntegerLiteral e) {
        return e;
    }

    public Object visit(DoubleLiteral e) {
        return e;
    }

    public Object visit(DecimalLiteral e) {
        return e;
    }

    public Object visit(ParExpr e) {
        this.printExprs(e.iterator());
        return e;
    }

    public Object visit(CntxItemExpr e) {
        return new VarRef(new QName("fs", "dot"));
    }

    public Object visit(FunctionCall e) {
        this.printExprs(e.iterator());
        return e;
    }

    public Object visit(SingleType e) {
        return e;
    }

    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return e;
    }

    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return e;
    }

    public Object visit(AnyKindTest e) {
        return e;
    }

    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return e;
    }

    public Object visit(TextTest e) {
        return e;
    }

    public Object visit(CommentTest e) {
        return e;
    }

    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return e;
    }

    public Object visit(AttributeTest e) {
        return e;
    }

    public Object visit(SchemaAttrTest e) {
        return e;
    }

    public Object visit(ElementTest e) {
        return e;
    }

    public Object visit(SchemaElemTest e) {
        return e;
    }

    private void printCollExprs(Iterator i) {
        while (i.hasNext()) {
            Collection exprs = (Collection)i.next();
            this.printExprs(exprs.iterator());
        }
    }

    public Object visit(AxisStep e) {
        Step s = (Step)e.step().accept(this);
        e.set_step(s);
        this.printCollExprs(e.iterator());
        return e;
    }

    public Object visit(FilterExpr e) {
        PrimaryExpr pe = (PrimaryExpr)e.primary().accept(this);
        e.set_primary(pe);
        this.printCollExprs(e.iterator());
        return e;
    }
}

