/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.buildship;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.util.Pair;
import org.gradle.tooling.model.GradleProject;

public class IgnoreBuildDirContribution
implements IToBeBuiltComputerContribution,
IStorage2UriMapperContribution,
ProjectConfigurator {
    private Set<IFolder> buildDirs = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<IProject, IFolder> buildDirsPerProject = new ConcurrentHashMap<IProject, IFolder>();

    public void init(InitializationContext context, IProgressMonitor monitor) {
    }

    public void configure(ProjectContext context, IProgressMonitor monitor) {
        IProject project = context.getProject();
        Optional gradleBuild = GradleCore.getWorkspace().getBuild(project);
        if (gradleBuild.isPresent()) {
            try {
                GradleProject gradleProject = (GradleProject)((GradleBuild)gradleBuild.get()).withConnection(connection -> (GradleProject)connection.getModel(GradleProject.class), (IProgressMonitor)new NullProgressMonitor());
                File buildDirectory = gradleProject.getBuildDirectory();
                File projectDirectory = gradleProject.getProjectDirectory();
                IPath relativePath = Path.fromOSString((String)projectDirectory.toPath().relativize(buildDirectory.toPath()).toString());
                IFolder buildDirAsFolder = project.getFolder(relativePath);
                this.buildDirs.add(buildDirAsFolder);
                this.buildDirsPerProject.put(project, buildDirAsFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unconfigure(ProjectContext context, IProgressMonitor monitor) {
        IFolder buildDir = this.buildDirsPerProject.remove(context.getProject());
        if (buildDir != null) {
            this.buildDirs.remove(buildDir);
        }
    }

    public boolean isRejected(IFolder folder) {
        return this.buildDirs.contains(folder);
    }

    public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
    }

    public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
    }

    public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        return false;
    }

    public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        return false;
    }

    public boolean isPossiblyHandled(IStorage storage) {
        return false;
    }

    public void initializeCache() {
    }

    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        return Collections.emptyList();
    }

    public URI getUri(IStorage storage) {
        return null;
    }
}

