/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.preferences.AntPropertiesBlock;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AntPropertiesTab
extends AbstractLaunchConfigurationTab
implements IAntBlockContainer {
    private Button fUseDefaultButton;
    private AntPropertiesBlock fAntPropertiesBlock = new AntPropertiesBlock(this);
    private boolean fSeparateJRE = true;

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setFont(parent.getFont());
        this.setControl((Control)top);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ant.ui.ant_properties_tab_context");
        top.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        top.setLayoutData((Object)gridData);
        this.createChangeProperties(top);
        Composite propertiesBlockComposite = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        propertiesBlockComposite.setLayout((Layout)layout);
        propertiesBlockComposite.setLayoutData((Object)new GridData(1808));
        this.fAntPropertiesBlock.createControl(propertiesBlockComposite, AntLaunchConfigurationMessages.AntPropertiesTab__Properties__6, AntLaunchConfigurationMessages.AntPropertiesTab_Property_f_iles__7);
        Dialog.applyDialogFont((Control)top);
    }

    private void createChangeProperties(Composite top) {
        this.fUseDefaultButton = this.createCheckButton(top, AntLaunchConfigurationMessages.AntPropertiesTab_6);
        this.fUseDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntPropertiesTab.this.toggleUseDefaultProperties();
                AntPropertiesTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void toggleUseDefaultProperties() {
        boolean enable = !this.fUseDefaultButton.getSelection();
        this.fAntPropertiesBlock.setEnabled(enable);
        if (!enable) {
            this.initializeAsGlobal(this.fSeparateJRE);
        }
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    public String getName() {
        return AntLaunchConfigurationMessages.AntPropertiesTab_P_roperties_8;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fSeparateJRE = AntUtil.isSeparateJREAntBuild(configuration);
        this.setErrorMessage(null);
        this.setMessage(null);
        Map properties = null;
        try {
            properties = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.AntPropertiesTab_Error_reading_configuration_9, ce);
        }
        String propertyFiles = null;
        try {
            propertyFiles = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.AntPropertiesTab_Error_reading_configuration_9, ce);
        }
        if (properties == null && propertyFiles == null) {
            this.initializeAsGlobal(this.fSeparateJRE);
        } else {
            this.fUseDefaultButton.setSelection(false);
            this.fAntPropertiesBlock.populatePropertyViewer(properties);
            String[] files = AntUtil.parseString(propertyFiles, ",");
            this.fAntPropertiesBlock.setPropertyFilesInput(files);
        }
        this.toggleUseDefaultProperties();
    }

    private void initializeAsGlobal(boolean separateVM) {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        List prefProperties = separateVM ? prefs.getRemoteAntProperties() : prefs.getProperties();
        this.fAntPropertiesBlock.setPropertiesInput(prefProperties.toArray(new Property[prefProperties.size()]));
        this.fAntPropertiesBlock.setPropertyFilesInput(AntCorePlugin.getPlugin().getPreferences().getCustomPropertyFiles(false));
        this.fAntPropertiesBlock.setTablesEnabled(false);
        this.fUseDefaultButton.setSelection(true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fUseDefaultButton.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
            return;
        }
        Object[] items = this.fAntPropertiesBlock.getProperties();
        HashMap<String, String> properties = null;
        if (items.length > 0) {
            properties = new HashMap<String, String>(items.length);
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                Property property = (Property)item;
                properties.put(property.getName(), property.getValue(false));
                ++n2;
            }
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        items = this.fAntPropertiesBlock.getPropertyFiles();
        String files = null;
        if (items.length > 0) {
            StringBuilder buff = new StringBuilder();
            Object[] objectArray = items;
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                Object item = objectArray[n3];
                String path = (String)item;
                buff.append(path);
                buff.append(',');
                ++n3;
            }
            files = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", files);
        this.fAntPropertiesBlock.saveSettings();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    public void setMessage(String message) {
        super.setMessage(message);
    }

    @Override
    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    @Override
    public Button createPushButton(Composite parent, String buttonText) {
        return super.createPushButton(parent, buttonText, null);
    }

    @Override
    public void update() {
        this.updateTargetsTab();
        this.updateLaunchConfigurationDialog();
    }

    private void updateTargetsTab() {
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
                break;
            }
            ++n2;
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.fSeparateJRE != AntUtil.isSeparateJREAntBuild((ILaunchConfiguration)workingCopy)) {
            this.initializeFrom((ILaunchConfiguration)workingCopy);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

