/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeAttributeValueFilter;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class CPartnerActivityValidator
extends CActivityValidator {
    protected INode fPartnerLinkNode;
    protected String fOperation;
    protected INode fPortType;
    protected INode fPartnerLinkType;
    protected boolean resolvedPartnerLinkType;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_CORRELATIONS, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
    }

    public void rule_LookupPartnerLink_0() {
        this.fPartnerLinkNode = this.mModelQuery.lookup(this.mNode, 2, this.mNode.getAttribute(AT_PARTNER_LINK));
    }

    public void rule_LookupPortType_0() {
        this.fPortType = this.mModelQuery.lookup(this.mNode, 12, this.mNode.getAttribute(AT_PORT_TYPE));
    }

    @ARule(sa=88, desc="Correlation set lookup, first associated scope, then ancestor scopes", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckOperationSet_0() {
        this.fOperation = this.getAttribute(this.mNode, AT_OPERATION, 1, Filters.NC_NAME, true);
    }

    @ARule(desc="Check if partner link exists", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckPartnerLink_2() {
        if (!this.checkAttributeNode(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 1)) {
            this.fPartnerLinkNode = null;
            return;
        }
        if (!this.checkValidator(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 1)) {
            this.fPartnerLinkNode = null;
            return;
        }
    }

    @ARule(desc="Check if port type exists", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckPortType_3() {
        if (this.fPortType == null) {
            return;
        }
        if (!this.checkAttributeNode(this.mNode, this.fPortType, AT_PORT_TYPE, 1)) {
            this.fPortType = null;
            return;
        }
        if (!this.checkValidator(this.mNode, this.fPortType, AT_PORT_TYPE, 1)) {
            this.fPortType = null;
            return;
        }
    }

    @ARule(desc="Check partner link type", author="michal.chmielewski@oracle.com", date="02/27/2007", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckPartnerLinkType_4() {
        if (this.isUndefined(this.fPartnerLinkNode)) {
            return;
        }
        this.fPartnerLinkType = this.mModelQuery.lookup(this.fPartnerLinkNode, 10, this.mNode.getAttribute(AT_PARTNER_LINK_TYPE));
        if (this.isDefined(this.fPartnerLinkType)) {
            this.resolvedPartnerLinkType = true;
        } else if (!this.checkValidator(this.fPartnerLinkNode, this.fPartnerLinkType, AT_PARTNER_LINK_TYPE, 0)) {
            this.fPartnerLinkType = null;
            this.resolvedPartnerLinkType = false;
        }
    }

    @ARule(desc="Check variable exists", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE", warnings="BPELC_REF_NODE_PROBLEMS")
    protected INode verifyVariable(INode varNode, QName atName) {
        if (varNode == null) {
            return varNode;
        }
        if (!this.checkAttributeNode(this.mNode, varNode, atName, 1)) {
            return null;
        }
        if (!this.checkValidator(this.mNode, varNode, atName, 1)) {
            return null;
        }
        return varNode;
    }

    protected INode lookupRoleNode(INode partnerLink, QName atName) {
        if (partnerLink == null) {
            return null;
        }
        String roleName = partnerLink.getAttribute(atName);
        if (this.isUndefined(partnerLink) || roleName == null) {
            return null;
        }
        INode role = this.getValue(partnerLink, "role." + roleName, null);
        if (this.isUndefined(role)) {
            IProblem problem = this.createError();
            problem.setAttribute("context.name", atName);
            problem.fill("BPELC_MISSING_ROLE", this.toString(this.mNode.nodeName()), this.ncName, this.mNode.getAttribute(AT_PARTNER_LINK), atName);
        }
        return role;
    }

    protected INode verifyPortTypeFromRole(INode role, QName atRole, INode portType) {
        if (this.isUndefined(role)) {
            return null;
        }
        INode portTypeFromRole = this.mModelQuery.lookup(role, 12, role.getAttribute(AT_PORT_TYPE));
        if (portType != null && !this.mModelQuery.check(2, portTypeFromRole, portType)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_MISMATCH_ROLE_PORT_TYPE", this.toString(this.mNode.nodeName()), this.ncName, this.mNode.getAttribute(AT_PORT_TYPE), this.fPartnerLinkNode.getAttribute(AT_NAME), atRole, this.mModelQuery.lookup(portTypeFromRole, 4, null, null));
        }
        return portTypeFromRole;
    }

    protected INode findMessageType(INode portType, String operationName, QName messageKind, boolean bError) {
        if (this.isUndefined(portType) || operationName == null) {
            return null;
        }
        List<INode> messages = this.lookupMessages(portType, operationName, messageKind);
        INode message = null;
        if (messages.size() == 0) {
            if (bError) {
                IProblem problem = this.createError();
                problem.fill("BPELC_PA__NO_MESSAGE", this.toString(this.mNode.nodeName()), portType, operationName, messageKind);
            }
            return null;
        }
        message = messages.get(0);
        INode msgType = this.mModelQuery.lookup(message, 7, message.getAttribute(WSDL_AT_MESSAGE));
        if (this.isUndefined(msgType)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PA__MSG_TYPE", this.toString(this.mNode.nodeName()), operationName, messageKind, message.getAttribute(WSDL_AT_MESSAGE));
        }
        return msgType;
    }

    protected List<INode> lookupMessages(INode portType, String operationName, QName messageKind) {
        return mSelector.selectNodes(portType, WSDL_ND_OPERATION, new NodeAttributeValueFilter(AT_NAME, operationName), messageKind);
    }
}

