/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.wsdl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDIncludeImpl;

public class Definitions
extends Validator {
    @Override
    @ARule(sa=-1, desc="Check WSDL definition", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC_IMPORT__UNRESOVED")
    protected void start() {
        super.start();
        Definition definition = (Definition)this.mModelQuery.adapt(this.mNode, EObject.class, 0);
        List<EObject> unresolved = this.findUnresolvedImports(definition);
        for (EObject obj : unresolved) {
            String location = "unkonwn";
            if (obj instanceof Import) {
                location = ((Import)obj).getLocationURI();
            } else if (obj instanceof XSDImportImpl) {
                location = ((XSDImportImpl)obj).getSchemaLocation();
            } else if (obj instanceof XSDIncludeImpl) {
                location = ((XSDIncludeImpl)obj).getSchemaLocation();
            }
            IProblem problem = this.createWarning(this.mModelQuery.adapt(obj, INode.class, 0));
            problem.fill("BPELC_IMPORT__UNRESOVED", this.toString(this.mNode.nodeName()), location, definition.getLocation());
        }
    }

    protected List<EObject> findUnresolvedImports(Definition definition) {
        if (definition == null) {
            return Collections.emptyList();
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        IFile file = (IFile)adapterManager.getAdapter((Object)definition, IResource.class);
        if (file != null && file.exists()) {
            try {
                file.deleteMarkers("org.eclispe.bpel.validator.marker", false, 2);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        ArrayList<EObject> imports = new ArrayList<EObject>();
        if (definition.getImports() != null) {
            for (List impList : definition.getImports().values()) {
                int i = 0;
                while (i < impList.size()) {
                    ImportImpl wsdlImport = (ImportImpl)impList.get(i);
                    wsdlImport.importDefinitionOrSchema();
                    XSDSchema schema = wsdlImport.getESchema();
                    Definition wsdlDefinition = wsdlImport.getEDefinition();
                    if (schema == null && wsdlDefinition == null) {
                        imports.add((EObject)wsdlImport);
                    }
                    imports.addAll(this.findUnresolvedImports(wsdlDefinition));
                    ++i;
                }
            }
        }
        if (definition.getETypes() != null) {
            List schemas = definition.getETypes().getSchemas();
            for (XSDSchema si : schemas) {
                for (XSDSchemaContent sc : si.getContents()) {
                    if (sc instanceof XSDIncludeImpl) {
                        XSDIncludeImpl inc = (XSDIncludeImpl)sc;
                        inc.getIncorporatedSchema();
                        if (inc.getResolvedSchema() == null) {
                            imports.add((EObject)inc);
                        }
                    }
                    if (!(sc instanceof XSDImportImpl)) continue;
                    XSDImportImpl imp = (XSDImportImpl)sc;
                    imp.importSchema();
                    if (imp.getResolvedSchema() != null) continue;
                    imports.add((EObject)imp);
                }
            }
        }
        return imports;
    }
}

