/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.model.ModelDecoratorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class FeatureDescriptor<T extends EObject>
extends ObjectDescriptor<T> {
    protected EStructuralFeature feature;
    protected int multiline = 0;
    protected Hashtable<String, Object> choiceOfValues;

    public FeatureDescriptor(ExtendedPropertiesAdapter<T> owner, T object, EStructuralFeature feature) {
        super(owner, object);
        this.feature = feature;
        Assert.isNotNull(object);
        Assert.isNotNull((Object)feature);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public String getLabel() {
        String s = ModelDecorator.getLabel((EModelElement)this.feature);
        if (s != null) {
            return s;
        }
        if (this.label == null) {
            IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(this.feature);
            this.label = propertyDescriptor != null ? propertyDescriptor.getDisplayName((Object)this.object) : ModelUtil.toCanonicalString(this.feature.getName());
        }
        return this.label;
    }

    @Override
    public String getTextValue() {
        if (this.textValue == null) {
            Object id;
            String t = null;
            EObject o = null;
            EStructuralFeature f = null;
            if (this.feature != null) {
                Object value = this.object.eGet(this.feature);
                if (value instanceof EObject) {
                    o = (EObject)value;
                } else if (value != null) {
                    t = value.toString();
                }
            }
            if (t == null && o != null) {
                f = o.eClass().getEStructuralFeature("name");
                if (f != null) {
                    String name = (String)o.eGet(f);
                    if (name != null && !name.isEmpty()) {
                        t = name;
                    }
                } else if (o instanceof FormalExpression && (t = ModelUtil.getExpressionBody((FormalExpression)o)) == null) {
                    t = "";
                }
            }
            if (t == null && o != null && (f = o.eClass().getEStructuralFeature("id")) != null && (id = o.eGet(f)) != null && !id.toString().isEmpty()) {
                t = id.toString();
            }
            return t == null ? "" : t;
        }
        return this.textValue == null ? "" : this.textValue;
    }

    public void setChoiceOfValues(Hashtable<String, Object> choiceOfValues) {
        this.choiceOfValues = choiceOfValues;
    }

    public void setChoiceOfValues(Collection values) {
        if (values != null) {
            this.choiceOfValues = new Hashtable();
            for (Object value : values) {
                if (value == null) continue;
                String text = this.getChoiceString(value);
                while (this.choiceOfValues.containsKey(text)) {
                    text = String.valueOf(text) + " ";
                }
                this.choiceOfValues.put(text, value);
            }
        }
    }

    public Hashtable<String, Object> getChoiceOfValues() {
        if (this.choiceOfValues == null) {
            List<EObject> values = null;
            try {
                IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(this.feature);
                if (propertyDescriptor != null) {
                    values = propertyDescriptor.getChoiceOfValues((Object)this.object);
                }
            }
            catch (Exception exception) {}
            if (values == null) {
                if (this.feature.getEType() instanceof EEnum) {
                    EEnum en = (EEnum)this.feature.getEType();
                    Hashtable<String, Object> choices = new Hashtable<String, Object>();
                    for (EEnumLiteral eEnumLiteral : en.getELiterals()) {
                        choices.put(eEnumLiteral.getLiteral(), eEnumLiteral.getInstance());
                    }
                    return choices;
                }
                values = ModelUtil.getAllReachableObjects(this.object, this.feature);
            }
            if (values != null) {
                Hashtable<String, Object> choices = new Hashtable<String, Object>();
                for (Object e : values) {
                    if (e == null) continue;
                    String text = this.getChoiceString(e);
                    if (text == null) {
                        text = "";
                    }
                    while (choices.containsKey(text)) {
                        text = String.valueOf(text) + " ";
                    }
                    choices.put(text, e);
                }
                return choices;
            }
        }
        return this.choiceOfValues;
    }

    public String getChoiceString(Object value) {
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eObject);
            if (adapter != null) {
                return adapter.getObjectDescriptor().getTextValue();
            }
            return ModelUtil.toCanonicalString(eObject.eClass().getName());
        }
        if (value instanceof Enumerator) {
            Enumerator e = (Enumerator)value;
            return e.getName();
        }
        return value.toString();
    }

    public void setMultiLine(boolean multiline) {
        this.multiline = multiline ? 1 : -1;
    }

    public boolean isMultiLine() {
        IItemPropertyDescriptor propertyDescriptor;
        if (this.multiline == 0 && (propertyDescriptor = this.getPropertyDescriptor(this.feature)) != null) {
            int n = this.multiline = propertyDescriptor.isMultiLine((Object)this.object) ? 1 : -1;
        }
        return this.multiline == 1;
    }

    public boolean isList() {
        return this.feature.isMany() && this.feature instanceof EReference && ((EReference)this.feature).isContainment();
    }

    public EClassifier getEType() {
        return this.feature.getEType();
    }

    public EObject createFeature(Resource resource, EClass eclass) {
        ExtendedPropertiesAdapter adapter;
        Object newFeature = null;
        if (eclass == null) {
            eclass = (EClass)this.getEType();
        }
        if (resource == null) {
            resource = this.getResource();
        }
        if ((adapter = ExtendedPropertiesAdapter.adapt(resource, eclass)) != null && ((newFeature = (Object)adapter.getObjectDescriptor().createObject(resource, eclass, null)).eContainer() != null || this.feature instanceof EAttribute || this.feature instanceof EReference && ((EReference)this.feature).isContainment())) {
            if (this.object.eGet(this.feature) instanceof List) {
                ((List)this.object.eGet(this.feature)).add(newFeature);
            } else {
                this.object.eSet(this.feature, newFeature);
            }
        }
        return newFeature;
    }

    public Object getValue() {
        return this.getValue(-1);
    }

    public Object getValue(int index) {
        if (this.hasStructuralFeatureFeature(this.object, this.feature)) {
            if (index >= 0 && this.isList()) {
                return ((List)this.object.eGet(this.feature)).get(index);
            }
            return this.object.eGet(this.feature);
        }
        if (this.isAnyAttribute(this.object, this.feature)) {
            Object value = null;
            try {
                value = this.object.eGet(this.feature);
            }
            catch (Exception exception) {}
            return value;
        }
        if (this.isExtensionAttribute(this.object, this.feature)) {
            List<Object> result = ModelDecorator.getAllExtensionAttributeValues(this.object, this.feature);
            if (result.size() == 0) {
                return null;
            }
            if (index >= 0) {
                return result.get(index);
            }
            return result.get(0);
        }
        return null;
    }

    public List<Object> getValueList() {
        if (this.isList()) {
            return (List)this.object.eGet(this.feature);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean setValue(Object value) {
        return this.setValue(value, -1);
    }

    public boolean setValue(Object value, final int index) {
        try {
            TransactionalEditingDomain domain;
            InsertionAdapter.executeIfNeeded(this.object);
            if (value instanceof EObject) {
                InsertionAdapter.executeIfNeeded((EObject)value);
            }
            if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    if (!(this.feature.getDefaultValue() instanceof String)) {
                        value = null;
                    }
                } else if (this.getEType() instanceof EDataType) {
                    EFactory factory;
                    EDataType eDataType = (EDataType)this.getEType();
                    try {
                        factory = eDataType.getEPackage().getEFactoryInstance();
                        value = factory.createFromString(eDataType, (String)value);
                    }
                    catch (Exception exception) {
                        factory = EcorePackage.eINSTANCE.getEFactoryInstance();
                        value = factory.createFromString(eDataType, (String)value);
                    }
                }
            }
            if ((domain = this.getEditingDomain(this.object)) != null) {
                final Object v = value;
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        FeatureDescriptor.this.internalSet(FeatureDescriptor.this.object, FeatureDescriptor.this.feature, v, index);
                        FeatureDescriptor.this.internalPostSet(v);
                    }
                });
            } else {
                this.internalSet(this.object, this.feature, value, index);
                this.internalPostSet(value);
            }
        }
        catch (Exception e) {
            ErrorUtils.showErrorMessage(e.getMessage());
            Activator.logError(e);
            return false;
        }
        return true;
    }

    private boolean hasStructuralFeatureFeature(EObject object, EStructuralFeature feature) {
        String name = feature.getName();
        if (object instanceof EClass) {
            return ((EClass)object).getEStructuralFeature(name) != null;
        }
        return object.eClass().getEStructuralFeature(name) != null;
    }

    private boolean isAnyAttribute(EObject object, EStructuralFeature feature) {
        if (this.hasStructuralFeatureFeature(object, feature)) {
            return false;
        }
        String name = feature.getName();
        return (feature = ModelDecorator.getAnyAttribute(object, name)) != null;
    }

    private boolean isExtensionAttribute(EObject object, EStructuralFeature feature) {
        if (this.hasStructuralFeatureFeature(object, feature)) {
            return false;
        }
        String name = feature.getName();
        return (feature = ModelDecorator.getExtensionAttribute(object, name)) != null;
    }

    private ModelDecorator getModelDecorator() {
        ModelDecorator modelDecorator = ModelDecoratorAdapter.getModelDecorator(this.feature.getEContainingClass().getEPackage());
        return modelDecorator;
    }

    protected void internalSet(T object, EStructuralFeature feature, Object value, int index) {
        if (this.hasStructuralFeatureFeature((EObject)object, feature) || this.isList()) {
            if (feature.isMany()) {
                if (value == null) {
                    ((List)object.eGet(feature)).clear();
                } else if (index < 0) {
                    ((List)object.eGet(feature)).add(value);
                } else {
                    ((List)object.eGet(feature)).set(index, value);
                }
            } else {
                object.eSet(feature, value);
            }
        } else {
            String name = feature.getName();
            if (feature instanceof EAttribute) {
                EStructuralFeature f = ModelDecorator.getAnyAttribute(object, name);
                if (f != null) {
                    object.eSet(f, value);
                } else {
                    String namespace = ExtendedMetaData.INSTANCE.getNamespace(feature);
                    String type = feature.getEType().getName();
                    ModelDecorator modelDecorator = this.getModelDecorator();
                    if (modelDecorator == null) {
                        modelDecorator = this.getModelDecorator();
                    }
                    modelDecorator.addAnyAttribute((EObject)object, namespace, name, type, value);
                }
            } else {
                ModelDecorator.addExtensionAttributeValue(this.getResource(), object, feature, value, index, false);
            }
        }
    }

    protected void internalPostSet(Object value) {
        if (value instanceof EObject) {
            Definitions definitions;
            ModelUtil.setID((EObject)value);
            if (value instanceof RootElement && ((RootElement)value).eContainer() == null && (definitions = ModelUtil.getDefinitions(this.object)) != null && !definitions.getRootElements().contains(value)) {
                definitions.getRootElements().add((RootElement)value);
            }
        }
    }

    public void unset() {
        this.setValue(this.feature.getDefaultValue());
    }

    @Override
    public boolean equals(Object obj) {
        Object thisValue = this.object.eGet(this.feature);
        if (thisValue == null && obj == null) {
            return true;
        }
        if (thisValue instanceof EObject && obj instanceof EObject) {
            return ExtendedPropertiesAdapter.compare((EObject)thisValue, (EObject)obj, false);
        }
        if (thisValue != null && obj != null) {
            return thisValue.equals(obj);
        }
        return false;
    }

    @Override
    public boolean similar(Object obj) {
        Object thisValue = this.object.eGet(this.feature);
        if (thisValue == null && obj == null) {
            return true;
        }
        if (thisValue instanceof EObject && obj instanceof EObject) {
            return ExtendedPropertiesAdapter.compare((EObject)thisValue, (EObject)obj, true);
        }
        if (thisValue != null && obj != null) {
            return thisValue.equals(obj);
        }
        return false;
    }

    @Deprecated
    public Hashtable<String, Object> getChoiceOfValues(Object context) {
        return this.getChoiceOfValues();
    }
}

