/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public enum AnchorSite {
    TOP("anchor.top"),
    BOTTOM("anchor.bottom"),
    LEFT("anchor.left"),
    RIGHT("anchor.right"),
    CENTER("anchor.center");

    private final String key;

    private AnchorSite(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static AnchorSite getSite(String key) {
        AnchorSite[] anchorSiteArray = AnchorSite.values();
        int n = anchorSiteArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnchorSite l = anchorSiteArray[n2];
            if (l.getKey().equals(key)) {
                return l;
            }
            ++n2;
        }
        return CENTER;
    }

    public static AnchorSite getSite(FixPointAnchor anchor) {
        return AnchorSite.getSite(FeatureSupport.getPropertyValue((PropertyContainer)anchor, "anchor.location"));
    }

    public static void setSite(FixPointAnchor anchor, AnchorSite site) {
        FeatureSupport.setPropertyValue((PropertyContainer)anchor, "anchor.location", site.getKey());
    }

    public static AnchorSite getNearestEdge(Shape shape, Point p) {
        int x;
        int y;
        GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge(shape, p);
        ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
        AnchorSite site = edge.isHorizontal() ? ((y = edge.getStart().getY()) == loc.getY() ? TOP : BOTTOM) : ((x = edge.getStart().getX()) == loc.getX() ? LEFT : RIGHT);
        return site;
    }

    public static AnchorSite getNearestEdge(Shape shape, Point p1, Point p2) {
        int x;
        int y;
        ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
        if (shape instanceof ConnectionDecorator) {
            int dy;
            Point pm = GraphicsUtil.getMidpoint(p1, p2);
            Connection c = ((ConnectionDecorator)shape).getConnection();
            GraphicsUtil.LineSegment lineSegment = null;
            Point start = GraphicsUtil.createPoint(c.getStart());
            Point end = GraphicsUtil.createPoint(c.getEnd());
            if (c instanceof FreeFormConnection) {
                double d;
                GraphicsUtil.LineSegment ls;
                double minDistance = Double.MAX_VALUE;
                FreeFormConnection ffc = (FreeFormConnection)c;
                Point p0 = start;
                for (Point p : ffc.getBendpoints()) {
                    ls = new GraphicsUtil.LineSegment(p0, p);
                    d = ls.getDistance(pm);
                    if (d < minDistance) {
                        minDistance = d;
                        lineSegment = ls;
                    }
                    p0 = p;
                }
                ls = new GraphicsUtil.LineSegment(p0, end);
                d = ls.getDistance(pm);
                if (d < minDistance) {
                    minDistance = d;
                    lineSegment = ls;
                }
            }
            if (lineSegment == null) {
                lineSegment = new GraphicsUtil.LineSegment(start, end);
            }
            if (lineSegment.isVertical()) {
                if (pm.getX() > lineSegment.getMiddle().getX()) {
                    return RIGHT;
                }
                return LEFT;
            }
            if (lineSegment.isHorizontal()) {
                if (pm.getY() > lineSegment.getMiddle().getY()) {
                    return BOTTOM;
                }
                return TOP;
            }
            int dx = Math.abs(pm.getX() - lineSegment.getMiddle().getX());
            if (dx < (dy = Math.abs(pm.getY() - lineSegment.getMiddle().getY()))) {
                if (pm.getY() > lineSegment.getMiddle().getY()) {
                    return BOTTOM;
                }
                return TOP;
            }
            if (pm.getX() > lineSegment.getMiddle().getX()) {
                return RIGHT;
            }
            return LEFT;
        }
        GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge(shape, p1, p2);
        AnchorSite site = edge.isHorizontal() ? ((y = edge.getStart().getY()) == loc.getY() ? TOP : BOTTOM) : ((x = edge.getStart().getX()) == loc.getX() ? LEFT : RIGHT);
        return site;
    }
}

