/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IElementFormatProvider;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesUpdateStatus;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICacheEntry;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProviderExtension2;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicyExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class FormattedValueRetriever {
    private final IVMNode fNode;
    private final ICachingVMProviderExtension2 fCache;
    private final IElementFormatProvider fElementFormatProvider;
    private final ServiceTracker fServiceTracker;
    private final Class<? extends IFormattedValues.IFormattedDataDMContext> fDmcType;
    private final String fPropertyPrefix;
    private final String PROP_AVAILABLE_FORMATS;
    private final String PROP_ACTIVE_FORMAT;
    private final String PROP_ACTIVE_FORMAT_VALUE;
    private final String PROP_BASE;

    public FormattedValueRetriever(IVMNode node, DsfSession session, Class<?> serviceClass, Class<? extends IFormattedValues.IFormattedDataDMContext> dmcType) {
        this(node, FormattedValueRetriever.createFilter(session, serviceClass), dmcType, null);
    }

    public FormattedValueRetriever(IVMNode node, DsfSession session, Class<?> serviceClass, Class<? extends IFormattedValues.IFormattedDataDMContext> dmcType, String propertyPrefix) {
        this(node, FormattedValueRetriever.createFilter(session, serviceClass), dmcType, propertyPrefix);
    }

    public FormattedValueRetriever(IVMNode node, Filter filter, Class<? extends IFormattedValues.IFormattedDataDMContext> dmcType, String propertyPrefix) {
        this.fNode = node;
        this.fCache = (ICachingVMProviderExtension2)node.getVMProvider();
        IVMProvider vmprovider = this.fNode.getVMProvider();
        this.fElementFormatProvider = vmprovider instanceof IElementFormatProvider ? (IElementFormatProvider)((Object)vmprovider) : null;
        this.fServiceTracker = new ServiceTracker(DsfUIPlugin.getBundleContext(), filter, null);
        this.fServiceTracker.open();
        this.fDmcType = dmcType;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        this.fPropertyPrefix = propertyPrefix;
        this.PROP_AVAILABLE_FORMATS = (String.valueOf(this.fPropertyPrefix) + "formatted_value_available_formats").intern();
        this.PROP_ACTIVE_FORMAT = (String.valueOf(this.fPropertyPrefix) + "formatted_value_active_format").intern();
        this.PROP_ACTIVE_FORMAT_VALUE = (String.valueOf(this.fPropertyPrefix) + "formatted_value_active_format_value").intern();
        this.PROP_BASE = (String.valueOf(this.fPropertyPrefix) + "formatted_value_base").intern();
    }

    private static Filter createFilter(DsfSession session, Class<?> serviceClass) {
        try {
            return DsfUIPlugin.getBundleContext().createFilter(DsfServices.createServiceFilter(serviceClass, (String)session.getId()));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unable to create service filter for " + serviceClass, e);
        }
    }

    public void dispose() {
        this.fServiceTracker.close();
    }

    @ConfinedToDsfExecutor(value="node.getExecutor()")
    public void update(final IPropertiesUpdate[] updates, final RequestMonitor rm) {
        this.retrieveElementActiveFormat(updates, new DataRequestMonitor<Map<IPropertiesUpdate, String>>(ImmediateExecutor.getInstance(), rm){

            protected void handleCompleted() {
                final Map elementFormatMap = (Map)this.getData();
                final Map<IPropertiesUpdate, String[]> cachedAvailableFormatsMap = FormattedValueRetriever.this.calcCachedAvailableFormatsMap(updates);
                if (cachedAvailableFormatsMap != null && cachedAvailableFormatsMap.size() == updates.length) {
                    FormattedValueRetriever.this.doUpdateWithAvailableFormats(updates, cachedAvailableFormatsMap, elementFormatMap, rm);
                } else {
                    IFormattedValues service = (IFormattedValues)FormattedValueRetriever.this.fServiceTracker.getService();
                    if (service == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Service not available " + FormattedValueRetriever.this.fServiceTracker, null));
                        rm.done();
                        return;
                    }
                    try {
                        service.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                FormattedValueRetriever.this.retrieveAvailableFormats(FormattedValueRetriever.this.calcOutstandingAvailableFormatsUpdates(updates, cachedAvailableFormatsMap), new DataRequestMonitor<Map<IPropertiesUpdate, String[]>>((this).FormattedValueRetriever.this.fNode.getVMProvider().getExecutor(), rm){

                                    protected void handleSuccess() {
                                        Map availableFormatsMap;
                                        if (cachedAvailableFormatsMap != null) {
                                            availableFormatsMap = cachedAvailableFormatsMap;
                                            availableFormatsMap.putAll((Map)this.getData());
                                        } else {
                                            availableFormatsMap = (Map)this.getData();
                                        }
                                        FormattedValueRetriever.this.doUpdateWithAvailableFormats(updates, availableFormatsMap, elementFormatMap, rm);
                                    }
                                });
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Service executor shut down " + service.getExecutor(), (Throwable)e));
                        rm.done();
                    }
                }
            }
        });
    }

    private void retrieveElementActiveFormat(IPropertiesUpdate[] updates, DataRequestMonitor<Map<IPropertiesUpdate, String>> rm) {
        if (this.fElementFormatProvider == null) {
            rm.setData(new HashMap(0));
            rm.done();
            return;
        }
        HashMap<IPropertiesUpdate, String> cachedMap = null;
        HashSet<IPropertiesUpdate> outstanding = null;
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (this.isElementFormatPropertyNeeded(update)) {
                String active = null;
                ICacheEntry cacheEntry = this.fCache.getCacheEntry(this.fNode, update.getViewerInput(), update.getElementPath());
                if (cacheEntry != null && cacheEntry.getProperties() != null) {
                    active = (String)cacheEntry.getProperties().get(this.PROP_ACTIVE_FORMAT);
                }
                if (active != null) {
                    if (cachedMap == null) {
                        cachedMap = new HashMap(updates.length * 4 / 3);
                    }
                    cachedMap.put(update, active);
                } else {
                    if (outstanding == null) {
                        outstanding = new HashSet<IPropertiesUpdate>(updates.length * 4 / 3);
                    }
                    outstanding.add(update);
                }
            }
            ++n2;
        }
        if (outstanding == null || outstanding.size() == 0) {
            rm.setData((Object)(cachedMap == null ? new HashMap<IPropertiesUpdate, String>(0) : cachedMap));
            rm.done();
            return;
        }
        if (cachedMap == null) {
            cachedMap = new HashMap(updates.length * 4 / 3);
        }
        final Map elementFormatMap = Collections.synchronizedMap(cachedMap);
        rm.setData(elementFormatMap);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
        int count = 0;
        for (final IPropertiesUpdate update : outstanding) {
            this.fElementFormatProvider.getActiveFormat(update.getPresentationContext(), this.fNode, update.getViewerInput(), update.getElementPath(), (DataRequestMonitor<String>)new ViewerDataRequestMonitor<String>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        String active = (String)this.getData();
                        if (update.getProperties().contains(FormattedValueRetriever.this.PROP_ACTIVE_FORMAT)) {
                            update.setProperty(FormattedValueRetriever.this.PROP_ACTIVE_FORMAT, active);
                        }
                        elementFormatMap.put(update, active);
                    }
                    countingRm.done();
                }
            });
            ++count;
        }
        countingRm.setDoneCount(count);
    }

    private Map<IPropertiesUpdate, String[]> calcCachedAvailableFormatsMap(IPropertiesUpdate[] updates) {
        HashMap<IPropertiesUpdate, String[]> cachedAvailableFormatsMap = null;
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            String[] availableFormats;
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            ICacheEntry cacheEntry = this.fCache.getCacheEntry(this.fNode, update.getViewerInput(), update.getElementPath());
            if (!(cacheEntry == null || cacheEntry.getProperties() == null || (availableFormats = (String[])cacheEntry.getProperties().get(this.PROP_AVAILABLE_FORMATS)) == null && this.isAvailableFormatsPropertyNeeded(update))) {
                if (cachedAvailableFormatsMap == null) {
                    cachedAvailableFormatsMap = new HashMap<IPropertiesUpdate, String[]>(updates.length * 4 / 3);
                }
                cachedAvailableFormatsMap.put(update, availableFormats);
            }
            ++n2;
        }
        return cachedAvailableFormatsMap;
    }

    private List<IPropertiesUpdate> calcOutstandingAvailableFormatsUpdates(IPropertiesUpdate[] updates, Map<IPropertiesUpdate, String[]> cachedAvailableFormatsMap) {
        if (cachedAvailableFormatsMap != null) {
            ArrayList<IPropertiesUpdate> outstandingUpdates = new ArrayList<IPropertiesUpdate>(updates.length - cachedAvailableFormatsMap.size());
            IPropertiesUpdate[] iPropertiesUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                if (!cachedAvailableFormatsMap.containsKey(update)) {
                    outstandingUpdates.add(update);
                }
                ++n2;
            }
            return outstandingUpdates;
        }
        return Arrays.asList(updates);
    }

    @ConfinedToDsfExecutor(value="service.getExecutor()")
    private void retrieveAvailableFormats(List<IPropertiesUpdate> updates, DataRequestMonitor<Map<IPropertiesUpdate, String[]>> rm) {
        IFormattedValues service = (IFormattedValues)this.fServiceTracker.getService();
        assert (service.getExecutor().isInExecutorThread());
        final Map availableFormats = Collections.synchronizedMap(new HashMap(updates.size() * 4 / 3));
        rm.setData(availableFormats);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)service.getExecutor(), rm);
        int count = 0;
        for (final IPropertiesUpdate update : updates) {
            IFormattedValues.IFormattedDataDMContext dmc;
            if (!this.isAvailableFormatsPropertyNeeded(update) || (dmc = this.getFormattedDataDMContext(update)) == null) continue;
            service.getAvailableFormats(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<String[]>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (update.getProperties().contains(FormattedValueRetriever.this.PROP_AVAILABLE_FORMATS)) {
                            update.setProperty(FormattedValueRetriever.this.PROP_AVAILABLE_FORMATS, this.getData());
                        }
                        if (((String[])this.getData()).length != 0) {
                            availableFormats.put(update, (String[])this.getData());
                        } else {
                            update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "No number formats available for " + update.getElement(), null));
                        }
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    countingRm.done();
                }
            });
            ++count;
        }
        countingRm.setDoneCount(count);
    }

    @ConfinedToDsfExecutor(value="fNode.getExecutor()")
    private void doUpdateWithAvailableFormats(IPropertiesUpdate[] updates, Map<IPropertiesUpdate, String[]> availableFormatsMap, Map<IPropertiesUpdate, String> elementFormatMap, final RequestMonitor rm) {
        final ArrayList<IPropertiesUpdate> outstandingUpdates = new ArrayList<IPropertiesUpdate>(updates.length);
        final HashMap<IPropertiesUpdate, List<String>> requestedFormatsMap = new HashMap<IPropertiesUpdate, List<String>>(updates.length * 4 / 3);
        final HashMap<IPropertiesUpdate, String> activeFormatsMap = new HashMap<IPropertiesUpdate, String>(updates.length * 4 / 3);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            String preferredFormat = FormattedValueVMUtil.getPreferredFormat(update.getPresentationContext());
            if (update.getProperties().contains("CurrentNumericStyle")) {
                update.setProperty("CurrentNumericStyle", preferredFormat);
            }
            String activeFormat = this.calcActiveFormat(update, preferredFormat, availableFormatsMap, elementFormatMap);
            if (update.getProperties().contains(this.PROP_ACTIVE_FORMAT)) {
                assert (activeFormat != null) : "Our caller should have provided the available formats if this property was specified; given available formats, an 'active' nomination is guaranteed.";
                update.setProperty(this.PROP_ACTIVE_FORMAT, activeFormat);
            }
            List<String> requestedFormats = this.calcRequestedFormats(update, activeFormat, availableFormatsMap.get(update));
            ICacheEntry cacheEntry = this.fCache.getCacheEntry(this.fNode, update.getViewerInput(), update.getElementPath());
            if (cacheEntry != null && cacheEntry.getProperties() != null) {
                IVMUpdatePolicyExtension updatePolicy = this.getVMUpdatePolicyExtension();
                Iterator<String> itr = requestedFormats.iterator();
                while (itr.hasNext()) {
                    String format = itr.next();
                    String formatProperty = FormattedValueVMUtil.getPropertyForFormatId(format, this.fPropertyPrefix);
                    Object value = cacheEntry.getProperties().get(formatProperty);
                    if (value == null && FormattedValueRetriever.canUpdateProperty(cacheEntry, updatePolicy, formatProperty)) continue;
                    itr.remove();
                    this.setUpdateFormatProperty(update, activeFormat, format, value);
                }
            }
            if (!requestedFormats.isEmpty()) {
                outstandingUpdates.add(update);
                requestedFormatsMap.put(update, requestedFormats);
                activeFormatsMap.put(update, activeFormat);
            }
            ++n2;
        }
        IFormattedValues service = (IFormattedValues)this.fServiceTracker.getService();
        if (service == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Service not available " + this.fServiceTracker, null));
            rm.done();
            return;
        }
        try {
            service.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    FormattedValueRetriever.this.doUpdateWithRequestedFormats(outstandingUpdates, requestedFormatsMap, activeFormatsMap, rm);
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Service executor shut down " + service.getExecutor(), (Throwable)e));
            rm.done();
        }
    }

    private IVMUpdatePolicyExtension getVMUpdatePolicyExtension() {
        if (this.fCache.getActiveUpdatePolicy() instanceof IVMUpdatePolicyExtension) {
            return (IVMUpdatePolicyExtension)this.fCache.getActiveUpdatePolicy();
        }
        return null;
    }

    private static boolean canUpdateProperty(ICacheEntry entry, IVMUpdatePolicyExtension updatePolicy, String property) {
        return !entry.isDirty() || updatePolicy != null && updatePolicy.canUpdateDirtyProperty(entry, property);
    }

    @ConfinedToDsfExecutor(value="service.getExecutor()")
    private void doUpdateWithRequestedFormats(List<IPropertiesUpdate> updates, Map<IPropertiesUpdate, List<String>> requestedFormatsMap, final Map<IPropertiesUpdate, String> activeFormatsMap, RequestMonitor monitor) {
        IFormattedValues service = (IFormattedValues)this.fServiceTracker.getService();
        assert (service.getExecutor().isInExecutorThread());
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), monitor);
        int count = 0;
        for (final IPropertiesUpdate update : updates) {
            IFormattedValues.IFormattedDataDMContext dmc = this.getFormattedDataDMContext(update);
            if (dmc == null) continue;
            List<String> requestedFormats = requestedFormatsMap.get(update);
            for (String requestedFormat : requestedFormats) {
                final IFormattedValues.FormattedValueDMContext formattedValueDmc = service.getFormattedValueContext(dmc, requestedFormat);
                service.getFormattedExpressionValue(formattedValueDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IFormattedValues.FormattedValueDMData>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            FormattedValueRetriever.this.setUpdateFormatProperty(update, (String)activeFormatsMap.get(update), formattedValueDmc.getFormatID(), ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                        } else {
                            update.setStatus(this.getStatus());
                        }
                        countingRm.done();
                    }
                });
                ++count;
            }
        }
        countingRm.setDoneCount(count);
    }

    private String calcActiveFormat(IPropertiesUpdate update, String preferredFormat, Map<IPropertiesUpdate, String[]> availableFormatsMap, Map<IPropertiesUpdate, String> elementFormatMap) {
        String[] availableFormats = availableFormatsMap.get(update);
        if (availableFormats != null && availableFormats.length != 0) {
            String elementFormat = elementFormatMap.get(update);
            if (elementFormat != null && this.isFormatAvailable(elementFormat, availableFormats)) {
                return elementFormat;
            }
            if (this.isFormatAvailable(preferredFormat, availableFormats)) {
                return preferredFormat;
            }
            return availableFormats[0];
        }
        return null;
    }

    private boolean isFormatAvailable(String format, String[] availableFormats) {
        String[] stringArray = availableFormats;
        int n = availableFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String availableFormat = stringArray[n2];
            if (availableFormat.equals(format)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<String> calcRequestedFormats(IPropertiesUpdate update, String activeFormat, String[] availableFormats) {
        ArrayList<String> requestedFormats = new ArrayList<String>(10);
        boolean activeFormatValueHandled = false;
        Iterator<String> itr = update.getProperties().iterator();
        while (itr.hasNext() || activeFormat != null && !activeFormatValueHandled) {
            String nextFormat;
            if (itr.hasNext()) {
                String propertyName = itr.next();
                if (!propertyName.startsWith(this.PROP_BASE)) continue;
                nextFormat = FormattedValueVMUtil.getFormatFromProperty(propertyName, this.fPropertyPrefix);
                if (nextFormat.equals(activeFormat)) {
                    activeFormatValueHandled = true;
                }
                if (availableFormats != null && !this.isFormatAvailable(nextFormat, availableFormats)) {
                    continue;
                }
            } else {
                nextFormat = activeFormat;
                activeFormatValueHandled = true;
            }
            requestedFormats.add(nextFormat);
        }
        return requestedFormats;
    }

    private void setUpdateFormatProperty(IPropertiesUpdate update, String activeFormat, String format, Object value) {
        String formatProperty = FormattedValueVMUtil.getPropertyForFormatId(format, this.fPropertyPrefix);
        if (value != null) {
            update.setProperty(formatProperty, value);
            if (update.getProperties().contains(this.PROP_ACTIVE_FORMAT_VALUE) && format.equals(activeFormat)) {
                update.setProperty(this.PROP_ACTIVE_FORMAT_VALUE, value);
            }
        } else {
            IStatus staleDataStatus = DsfUIPlugin.newErrorStatus(10001, "Cache contains stale data. Refresh view.", null);
            if (update.getProperties().contains(this.PROP_ACTIVE_FORMAT_VALUE) && format.equals(activeFormat)) {
                PropertiesUpdateStatus.getPropertiesStatus(update).setStatus(new String[]{this.PROP_ACTIVE_FORMAT_VALUE, formatProperty}, staleDataStatus);
            } else {
                PropertiesUpdateStatus.getPropertiesStatus(update).setStatus(formatProperty, staleDataStatus);
            }
        }
    }

    private boolean isAvailableFormatsPropertyNeeded(IPropertiesUpdate update) {
        return update.getProperties().contains(this.PROP_AVAILABLE_FORMATS) || update.getProperties().contains(this.PROP_ACTIVE_FORMAT) || update.getProperties().contains(this.PROP_ACTIVE_FORMAT_VALUE);
    }

    private boolean isElementFormatPropertyNeeded(IPropertiesUpdate update) {
        if (this.fElementFormatProvider == null) {
            return false;
        }
        return update.getProperties().contains(this.PROP_ACTIVE_FORMAT) || update.getProperties().contains(this.PROP_ACTIVE_FORMAT_VALUE);
    }

    private IFormattedValues.IFormattedDataDMContext getFormattedDataDMContext(IPropertiesUpdate update) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (update.getElement() instanceof IDMVMContext) {
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)update.getElement()).getDMContext(), this.fDmcType);
        }
        if (dmc == null) {
            update.setStatus(DsfUIPlugin.newErrorStatus(10002, "Update element did not contain a valid context: " + this.fDmcType, null));
        }
        return dmc;
    }
}

