/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable;

import java.util.Iterator;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.partition.bag.PartitionImmutableBag;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;

public abstract class AbstractImmutableBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableBag<T> {
    @Override
    public ImmutableBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject(Predicates.in(elements));
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return this;
    }

    @Override
    public ImmutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public <P> ImmutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> ImmutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public PartitionImmutableBag<T> partition(Predicate<? super T> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEachWithOccurrences((each, occurrences) -> {
            MutableBagIterable bucket = predicate.accept(each) ? partitionMutableBag.getSelected() : partitionMutableBag.getRejected();
            bucket.addOccurrences(each, occurrences);
        });
        return partitionMutableBag.toImmutable();
    }

    @Override
    public <P> PartitionImmutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEachWithOccurrences((each, occurrences) -> {
            MutableBagIterable bucket = predicate.accept((Object)each, (Object)parameter) ? partitionMutableBag.getSelected() : partitionMutableBag.getRejected();
            bucket.addOccurrences(each, occurrences);
        });
        return partitionMutableBag.toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    public <V> ImmutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return this.collectWithOccurrences(function, Bags.mutable.empty()).toImmutable();
    }

    @Override
    public <P, V> ImmutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public ImmutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanHashBag()).toImmutable();
    }

    @Override
    public ImmutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteHashBag()).toImmutable();
    }

    @Override
    public ImmutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharHashBag()).toImmutable();
    }

    @Override
    public ImmutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleHashBag()).toImmutable();
    }

    @Override
    public ImmutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatHashBag()).toImmutable();
    }

    @Override
    public ImmutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntHashBag()).toImmutable();
    }

    @Override
    public ImmutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongHashBag()).toImmutable();
    }

    @Override
    public ImmutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortHashBag()).toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        MutableList result = this.occurrencesSortingBy(n, item -> -item.getTwo(), Lists.fixedSize.empty());
        return result.toImmutable();
    }

    @Override
    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        MutableList result = this.occurrencesSortingBy(n, ObjectIntPair::getTwo, Lists.fixedSize.empty());
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size())).toImmutable();
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = this.iterator();
        MutableList result = Lists.mutable.empty();
        while (iterator.hasNext()) {
            MutableBag batch = Bags.mutable.empty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch.toImmutable());
        }
        return result.toImmutable();
    }
}

