/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogColumn;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class ASETableColumnLoader
extends JDBCTableColumnLoader {
    private static final String ATTR_COL_NAME = "COLUMN_NAME";
    String oldCatalog = null;
    Connection conn = null;
    PreparedStatement stmt = null;

    public ASETableColumnLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    protected ResultSet createResultSet() throws SQLException {
        Table table = this.getTable();
        String query = null;
        String catalog = table.getSchema().getCatalog().getName();
        int tableId = ((ICatalogTable)table).getTableId();
        this.conn = ((ICatalogObject)table).getConnection();
        query = "select c.name as COLUMN_NAME from syscolumns c where id = ? order by c.colid";
        ResultSet rs = null;
        this.oldCatalog = this.conn.getCatalog();
        this.conn.setCatalog(catalog);
        this.stmt = this.conn.prepareStatement(query);
        this.stmt.setInt(1, tableId);
        try {
            rs = this.stmt.executeQuery();
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
            throw e;
        }
        return rs;
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
        try {
            if (this.oldCatalog != null) {
                this.conn.setCatalog(this.oldCatalog);
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    protected void initialize(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString(ATTR_COL_NAME));
    }

    protected Column createColumn() {
        return new SybaseASECatalogColumn();
    }
}

