/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheInfo;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheStrategyType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECache;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEFuncBasedIndexMember;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEIndexImpl;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionSegmentPair;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogIndex
extends SybaseASEIndexImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3906363835747938352L;
    public static final int IDX_STATUS_IGNORE_DUPKEYS = 1;
    public static final int IDX_STATUS_ABORT_DUPROWS = 4;
    public static final int IDX_STATUS_CLUSTERED = 16;
    public static final int IDX_STATUS_UNIQUE = 2;
    public static final int IDX_STATUS_ALLOW_DUPROWS = 64;
    public static final int IDX_STATUS_SORTED = 512;
    public static final int IDX_STATUS_SORTEDCLUSTERED = 128;
    public static final int IDX_STATUS_SUSPECT = 32768;
    public static final int IDX_STATUS2_SUSPECT = 8192;
    public static final int IDX_STATUS2_DATA_CLUSTERED = 512;
    public static final int IDX_STATUS2_PREFETCH_UNABLE = 16;
    public static final int IDX_STATUS2_MRU_UNABLE = 32;
    public static final int COL_STATUS3_FUNC_EXPRESSION = 1;
    public static final int PT_LOCAL_STATUS = 8;
    public static final int PT_NAME_DEFINED = 4;
    private Boolean isIndexInfoLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            this.isIndexInfoLoaded = Boolean.FALSE;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return this.isSystemGenerated();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getTable()).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getMembers() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalIndex() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isLocalIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheInfo getCacheInfo() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getCacheInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getPartitions() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowDuplicateRow() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isAllowDuplicateRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isClustered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFillFactor() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getFillFactor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoreDuplicateKey() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isIgnoreDuplicateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoreDuplicateRow() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isIgnoreDuplicateRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRowPerPage() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getMaxRowPerPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASESegment getSegment() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.getSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSortedData() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isSortedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspect() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isSuspect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnique() {
        Boolean bl = this.isIndexInfoLoaded;
        synchronized (bl) {
            if (!this.isIndexInfoLoaded.booleanValue()) {
                this.loadIndexInfo();
            }
        }
        return super.isUnique();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 13: {
                this.getMembers();
                break;
            }
            case 29: {
                this.getCacheInfo();
                break;
            }
            case 23: {
                this.isLocalIndex();
                break;
            }
            case 24: {
                this.getPartitions();
                break;
            }
            case 27: {
                this.isAllowDuplicateRow();
                break;
            }
            case 9: {
                this.isClustered();
                break;
            }
            case 10: {
                this.getFillFactor();
                break;
            }
            case 19: {
                this.isIgnoreDuplicateKey();
                break;
            }
            case 21: {
                this.isIgnoreDuplicateRow();
                break;
            }
            case 17: {
                this.getMaxRowPerPage();
                break;
            }
            case 22: {
                this.getSegment();
                break;
            }
            case 20: {
                this.isSortedData();
                break;
            }
            case 28: {
                this.isSuspect();
                break;
            }
            case 12: {
                this.isSystemGenerated();
                break;
            }
            case 11: {
                this.isUnique();
            }
        }
        return super.eIsSet(eFeature);
    }

    private void loadIndexInfo() {
        boolean deliver;
        block6: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT I.indid, I.status, I.keycnt, I.maxrowsperpage, I.fill_factor, I.res_page_gap,S.name,I.status2 FROM sysindexes I, syssegments S WHERE I.id = ? AND I.name = ? AND I.segment = S.segment AND I.indid BETWEEN 1 AND 254 AND ((I.status & 16 = 16 OR I.status2 & 512 = 512) OR (I.status & 16 = 0 AND I.status2 & 512 = 0))");
                    stmt.setInt(1, ((ICatalogTable)this.getTable()).getTableId());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int indid = rs.getInt(1);
                        int status = rs.getInt(2);
                        int keycnt = rs.getInt(3);
                        int maxrowsperpage = rs.getInt(4);
                        int fill_factor = rs.getInt(5);
                        int res_page_gap = rs.getInt(6);
                        String segmentName = rs.getString(7);
                        int status2 = rs.getInt(8);
                        super.setMaxRowPerPage(maxrowsperpage);
                        super.setFillFactor(fill_factor);
                        super.setReversePageGap(res_page_gap);
                        boolean ignoreDuplicateKeys = (status & 1) != 0;
                        boolean isAbortDuplicateRows = (status & 4) != 0;
                        boolean isUnique = (status & 2) != 0;
                        boolean isClustered = (status & 0x10) != 0 || (status2 & 0x200) != 0;
                        boolean isAllowDuplicateRows = (status & 0x40) != 0 || !isUnique && isClustered && indid > 1;
                        boolean isSortedData = (status & 0x200) != 0;
                        boolean isSuspect = (status & 0x8000) != 0 || (status2 & 0x2000) != 0;
                        super.setIgnoreDuplicateKey(ignoreDuplicateKeys);
                        super.setAllowDuplicateRow(isAllowDuplicateRows);
                        super.setIgnoreDuplicateRow(isAbortDuplicateRows);
                        super.setUnique(isUnique);
                        super.setClustered(isClustered);
                        super.setSortedData(isSortedData);
                        super.setSuspect(isSuspect);
                        SybaseASESegment segment = this.getSegment(segmentName);
                        super.setSegment(segment);
                        this.loadIndexColumns(indid, keycnt, conn);
                        this.loadIndexCache(status2, indid, conn);
                        if (!((SybaseASEDatabase)this.getCatalogDatabase()).isPartitionsApplicable()) continue;
                        this.loadPartitionInfo();
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.isIndexInfoLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    private void loadIndexColumns(int indid, int keyCount, Connection conn) {
        DatabaseDefinition dbDef = this.getDatabaseDefinition();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList indexMemberList = super.getMembers();
        indexMemberList.clear();
        if (indid != 1) {
            --keyCount;
        }
        Table parent = this.getTable();
        int i = 0;
        while (i < keyCount) {
            block9: {
                ResultSet rs = null;
                PreparedStatement stmt = null;
                String oldCatalog = null;
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                        String fullTableName = ASEUtil.getFullQuatifiedName((SQLObject)parent);
                        stmt = conn.prepareStatement("SELECT COL_NAME = INDEX_COL(?, ?, ?), INDEX_COLORDER(?, ?, ?)");
                        stmt.setString(1, fullTableName);
                        stmt.setInt(2, indid);
                        stmt.setInt(3, i + 1);
                        stmt.setString(4, fullTableName);
                        stmt.setInt(5, indid);
                        stmt.setInt(6, i + 1);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            String colName = rs.getString(1);
                            String order = rs.getString(2);
                            if (colName == null) continue;
                            IndexMember im = SybaseASECatalogUtils.getIndexMember(dbDef, this, colName, order, conn);
                            if (im.getColumn() == null && im instanceof SybaseASEFuncBasedIndexMember && ((SybaseASEFuncBasedIndexMember)im).getColumnExpression() == null) {
                                throw new UnsupportedOperationException("Fail to retrieve index column info");
                            }
                            indexMemberList.add((Object)im);
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw throwable;
                }
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            }
            ++i;
        }
        this.eSetDeliver(deliver);
    }

    private void loadIndexCache(int status2, int idxid, Connection connection) {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String cacheName = SybaseASECatalogUtils.getIndexCache(this, idxid, connection);
        if (cacheName != null) {
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            CacheInfo cacheInfo = (CacheInfo)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo());
            SybaseASECache cache = (SybaseASECache)ASEUtil.getSQLObject((Collection)((SybaseASEDatabase)this.getCatalogDatabase()).getCaches(), cacheName);
            cacheInfo.setCache(cache);
            int cacheStrategy = this.getIndexCacheStrategy(status2);
            cacheInfo.setCacheStrategy(cacheStrategy);
            this.setCacheInfo(cacheInfo);
        }
        this.eSetDeliver(deliver);
    }

    private void loadPartitionInfo() {
        boolean deliver;
        block6: {
            EList partitionList = super.getPartitions();
            partitionList.clear();
            Connection conn = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name,status3 = isnull(i.status3,0), status = isnull(p.status,0) from syspartitions p, sysindexes i, syssegments s where i.id = p.id and i.id = object_id(?) and p.indid >0 and i.indid< 255 and i.indid = p.indid and s.segment = p.segment  and i.conditionid is not null and p.name like '%' and i.name like ? order by 1");
                    stmt.setString(1, ASEUtil.getFullQuatifiedName((SQLObject)this.getTable()));
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    boolean isLocalIndex = false;
                    boolean isPartitionNameSet = false;
                    while (rs.next()) {
                        int status3 = rs.getInt(3);
                        boolean bl = isLocalIndex = (status3 & 8) != 0;
                        if (!isLocalIndex) continue;
                        int status = rs.getInt(4);
                        boolean bl2 = isPartitionNameSet = (status & 4) != 0;
                        if (!isPartitionNameSet) continue;
                        String partitionName = rs.getString(1);
                        SybaseASESegment segment = this.getSegment(rs.getString(2));
                        DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
                        PartitionSegmentPair partitionInfo = (PartitionSegmentPair)factory.create(PartitionPackage.eINSTANCE.getPartitionSegmentPair());
                        partitionInfo.setPartitionName(partitionName);
                        partitionInfo.setSegment(segment);
                        partitionList.add((Object)partitionInfo);
                    }
                    this.setLocalIndex(isLocalIndex);
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
    }

    private SybaseASESegment getSegment(String segmentName) {
        SybaseASECatalog catalog = (SybaseASECatalog)((SybaseASECatalogSchema)this.getTable().getSchema()).getCatalog();
        EList segmentList = catalog.getSegments();
        int i = 0;
        while (i < segmentList.size()) {
            SybaseASESegment seg = (SybaseASESegment)segmentList.get(i);
            if (seg.getName().equals(segmentName)) {
                return seg;
            }
            ++i;
        }
        return null;
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getTable().getSchema().getCatalog().getDatabase();
        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
        return dbDef;
    }

    private int getIndexCacheStrategy(int status2) {
        boolean isPrefetchUnable = (status2 & 0x10) != 0;
        boolean isMRUUnable = (status2 & 0x20) != 0;
        int cacheStrategy = 0;
        if (!isPrefetchUnable) {
            cacheStrategy |= CacheStrategyType.PREFETCH_LITERAL.getValue();
        }
        if (!isMRUUnable) {
            cacheStrategy |= CacheStrategyType.MRU_LITERAL.getValue();
        }
        return cacheStrategy;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

