/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.internal.core.services.databinding.DefaultRealm;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsSegmentResolver;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterListResultEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterValueResultEMF;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="databindingService", service={EMFFormsDatabinding.class, EMFFormsDatabindingEMF.class, EMFFormsSegmentResolver.class})
public class EMFFormsDatabindingImpl
implements EMFFormsDatabindingEMF,
EMFFormsSegmentResolver {
    private static final RankingHelper<DomainModelReferenceConverterEMF> DMR_RANKING_HELPER = new RankingHelper(DomainModelReferenceConverter.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));
    private static final RankingHelper<DomainModelReferenceSegmentConverterEMF> SEGMENTS_RANKING_HELPER = new RankingHelper(DomainModelReferenceSegmentConverterEMF.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));
    private final Set<DomainModelReferenceConverterEMF> referenceConverters = new LinkedHashSet<DomainModelReferenceConverterEMF>();
    private final Set<DomainModelReferenceSegmentConverterEMF> segmentConverters = new LinkedHashSet<DomainModelReferenceSegmentConverterEMF>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDomainModelReferenceSegmentConverter(DomainModelReferenceSegmentConverterEMF converter) {
        this.segmentConverters.add(converter);
    }

    protected void removeDomainModelReferenceSegmentConverter(DomainModelReferenceSegmentConverterEMF converter) {
        this.segmentConverters.remove(converter);
    }

    @Override
    public IObservableValue getObservableValue(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)object).notNull();
        IEMFValueProperty valueProperty = this.getValueProperty(domainModelReference, object);
        Realm realm = Realm.getDefault();
        if (realm != null) {
            return valueProperty.observe((Object)object);
        }
        DefaultRealm dr = new DefaultRealm();
        IObservableValue observableValue = valueProperty.observe((Object)object);
        dr.dispose();
        return observableValue;
    }

    @Override
    public IEMFValueProperty getValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
            return bestConverter.convertToValueProperty(domainModelReference, object);
        }
        Assert.create((Object)object).notNull();
        EditingDomain editingDomain = this.getEditingDomain(object);
        return this.internalGetValueProperty(domainModelReference, object.eClass(), editingDomain);
    }

    @Override
    public IEMFValueProperty getValueProperty(VDomainModelReference domainModelReference, EClass rootEClass) throws DatabindingFailedException {
        return this.getValueProperty(domainModelReference, rootEClass, null);
    }

    @Override
    public IEMFValueProperty getValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
            return bestConverter.convertToValueProperty(domainModelReference, rootEClass, editingDomain);
        }
        Assert.create((Object)rootEClass).notNull();
        return this.internalGetValueProperty(domainModelReference, rootEClass, editingDomain);
    }

    private IEMFValueProperty internalGetValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        EList segments = domainModelReference.getSegments();
        DomainModelReferenceSegmentConverterEMF firstConverter = this.getBestDomainModelReferenceSegmentConverter((VDomainModelReferenceSegment)segments.get(0));
        SegmentConverterValueResultEMF converterResult = firstConverter.convertToValueProperty((VDomainModelReferenceSegment)segments.get(0), rootEClass, editingDomain);
        IEMFValueProperty resultProperty = converterResult.getValueProperty();
        int i = 1;
        while (i < segments.size()) {
            EClass nextEClass = this.unpackNextEClass(converterResult.getNextEClass(), domainModelReference, (VDomainModelReferenceSegment)segments.get(i));
            VDomainModelReferenceSegment segment = (VDomainModelReferenceSegment)segments.get(i);
            DomainModelReferenceSegmentConverterEMF bestConverter = this.getBestDomainModelReferenceSegmentConverter(segment);
            converterResult = bestConverter.convertToValueProperty(segment, nextEClass, editingDomain);
            IEMFValueProperty nextProperty = converterResult.getValueProperty();
            resultProperty = resultProperty.value(nextProperty);
            ++i;
        }
        return resultProperty;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDomainModelReferenceConverter(DomainModelReferenceConverterEMF converter) {
        this.referenceConverters.add(converter);
    }

    protected void removeDomainModelReferenceConverter(DomainModelReferenceConverterEMF converter) {
        this.referenceConverters.remove(converter);
    }

    @Override
    public IObservableList getObservableList(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)object).notNull();
        IEMFListProperty listProperty = this.getListProperty(domainModelReference, object);
        Realm realm = Realm.getDefault();
        if (realm != null) {
            return listProperty.observe((Object)object);
        }
        DefaultRealm dr = new DefaultRealm();
        IObservableList observableList = listProperty.observe((Object)object);
        dr.dispose();
        return observableList;
    }

    @Override
    public IEMFListProperty getListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
            return bestConverter.convertToListProperty(domainModelReference, object);
        }
        Assert.create((Object)object).notNull();
        EditingDomain editingDomain = this.getEditingDomain(object);
        DomainModelReferenceSegmentConverterEMF firstConverter = this.getBestDomainModelReferenceSegmentConverter((VDomainModelReferenceSegment)segments.get(0));
        if (segments.size() == 1) {
            return firstConverter.convertToListProperty((VDomainModelReferenceSegment)segments.get(0), object.eClass(), editingDomain).getListProperty();
        }
        SegmentConverterValueResultEMF converterResult = firstConverter.convertToValueProperty((VDomainModelReferenceSegment)segments.get(0), object.eClass(), editingDomain);
        IEMFValueProperty valueProperty = converterResult.getValueProperty();
        EClass nextEClass = this.unpackNextEClass(converterResult.getNextEClass(), domainModelReference, (VDomainModelReferenceSegment)segments.get(0));
        int i = 1;
        while (i < segments.size() - 1) {
            VDomainModelReferenceSegment segment = (VDomainModelReferenceSegment)segments.get(i);
            DomainModelReferenceSegmentConverterEMF bestConverter = this.getBestDomainModelReferenceSegmentConverter(segment);
            SegmentConverterValueResultEMF nextConverterResult = bestConverter.convertToValueProperty(segment, nextEClass, editingDomain);
            IEMFValueProperty nextProperty = nextConverterResult.getValueProperty();
            nextEClass = this.unpackNextEClass(nextConverterResult.getNextEClass(), domainModelReference, segment);
            valueProperty = valueProperty.value(nextProperty);
            ++i;
        }
        int lastIndex = segments.size() - 1;
        DomainModelReferenceSegmentConverterEMF lastConverter = this.getBestDomainModelReferenceSegmentConverter((VDomainModelReferenceSegment)segments.get(lastIndex));
        SegmentConverterListResultEMF converterListResult = lastConverter.convertToListProperty((VDomainModelReferenceSegment)segments.get(lastIndex), nextEClass, editingDomain);
        return valueProperty.list(converterListResult.getListProperty());
    }

    private DomainModelReferenceConverterEMF getBestDomainModelReferenceConverter(VDomainModelReference domainModelReference) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        DomainModelReferenceConverterEMF bestConverter = (DomainModelReferenceConverterEMF)DMR_RANKING_HELPER.getHighestRankingElement(this.referenceConverters, converter -> converter.isApplicable(domainModelReference));
        if (bestConverter == null) {
            throw new DatabindingFailedException("No applicable DomainModelReferenceConverter could be found.");
        }
        return bestConverter;
    }

    @Override
    public EStructuralFeature extractFeature(IObservableValue observableValue) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableValue)) {
            return ((IEMFObservable)IEMFObservable.class.cast(observableValue)).getStructuralFeature();
        }
        throw new DatabindingFailedException(String.format("The IObservableValue class %1$s is not supported!", observableValue.getClass().getName()));
    }

    @Override
    public EStructuralFeature extractFeature(IObservableList observableList) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableList)) {
            return ((IEMFObservable)IEMFObservable.class.cast(observableList)).getStructuralFeature();
        }
        throw new DatabindingFailedException(String.format("The IObservableList class %1$s is not supported!", observableList.getClass().getName()));
    }

    @Override
    public EObject extractObserved(IObservableValue observableValue) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableValue)) {
            return (EObject)((IEMFObservable)IEMFObservable.class.cast(observableValue)).getObserved();
        }
        throw new DatabindingFailedException(String.format("The IObservableValue class %1$s is not supported!", observableValue.getClass().getName()));
    }

    @Override
    public EObject extractObserved(IObservableList observableList) throws DatabindingFailedException {
        if (IEMFObservable.class.isInstance(observableList)) {
            return (EObject)((IEMFObservable)IEMFObservable.class.cast(observableList)).getObserved();
        }
        throw new DatabindingFailedException(String.format("The IObservableList class %1$s is not supported!", observableList.getClass().getName()));
    }

    @Override
    public EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)object).notNull();
        EList segments = domainModelReference.getSegments();
        if (segments.isEmpty()) {
            DomainModelReferenceConverterEMF bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
            Realm realm = Realm.getDefault();
            if (realm != null) {
                return bestConverter.getSetting(domainModelReference, object);
            }
            DefaultRealm dr = new DefaultRealm();
            EStructuralFeature.Setting setting = bestConverter.getSetting(domainModelReference, object);
            dr.dispose();
            return setting;
        }
        EStructuralFeature.Setting setting = this.resolveSegment((VDomainModelReferenceSegment)segments.get(0), object);
        int i = 1;
        while (i < segments.size()) {
            VDomainModelReferenceSegment segment = (VDomainModelReferenceSegment)segments.get(i);
            Object nextObject = setting.get(true);
            if (!EObject.class.isInstance(nextObject)) {
                throw new DatabindingFailedException(String.format("The Setting could not be fully resolved because an intermediate Object was no EObject or was null. The DMR was %1$s. The last resolved segment was %2$s. The root EObject was %3$s.", domainModelReference, segments.get(i - 1), object));
            }
            EObject nextEObject = (EObject)nextObject;
            setting = this.resolveSegment(segment, nextEObject);
            ++i;
        }
        return setting;
    }

    private DomainModelReferenceSegmentConverterEMF getBestDomainModelReferenceSegmentConverter(VDomainModelReferenceSegment segment) throws DatabindingFailedException {
        DomainModelReferenceSegmentConverterEMF bestConverter = (DomainModelReferenceSegmentConverterEMF)SEGMENTS_RANKING_HELPER.getHighestRankingElement(this.segmentConverters, converter -> converter.isApplicable(segment));
        if (bestConverter == null) {
            throw new DatabindingFailedException(String.format("No suitable DomainModelReferenceSegmentConverter could be found for segment %1$s", segment));
        }
        return bestConverter;
    }

    private EClass unpackNextEClass(Optional<EClass> nextEClass, VDomainModelReference domainModelReference, VDomainModelReferenceSegment segment) throws DatabindingFailedException {
        return nextEClass.orElseThrow(() -> new DatabindingFailedException(String.format("The Segment [%1$s] could not be resolved because this segment's root EClass could not be resolved from the preceding segment. The DMR is %2$s.", segment, domainModelReference)));
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }

    @Override
    public EStructuralFeature.Setting resolveSegment(VDomainModelReferenceSegment segment, EObject domainObject) throws DatabindingFailedException {
        DomainModelReferenceSegmentConverterEMF bestConverter = this.getBestDomainModelReferenceSegmentConverter(segment);
        return bestConverter.getSetting(segment, domainObject);
    }
}

