/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.highlighting;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Port;
import org.eclipse.gef.dot.internal.ui.language.highlighting.DotSubgrammarHighlighter;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class DotSemanticHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    public void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            AbstractRule r;
            block24: {
                EObject grammarElement = node.getGrammarElement();
                if (!(grammarElement instanceof RuleCall)) continue;
                RuleCall rc = (RuleCall)grammarElement;
                r = rc.getRule();
                EObject c = grammarElement.eContainer();
                if (!r.getName().equals("ID")) break block24;
                EObject semanticElement = node.getSemanticElement();
                switch (((Assignment)c).getFeature()) {
                    case "name": {
                        if (semanticElement instanceof DotGraph) {
                            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"graph_name"});
                            break;
                        }
                        if (semanticElement instanceof NodeStmt || semanticElement instanceof NodeId) {
                            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"node_name"});
                            break;
                        }
                        if (semanticElement instanceof Attribute) {
                            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"attribute_name"});
                            break;
                        }
                        if (!(semanticElement instanceof Port)) break;
                        acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"port_name"});
                        break;
                    }
                    case "value": {
                        if (!(semanticElement instanceof Attribute)) break;
                        switch (((Attribute)semanticElement).getName().toValue()) {
                            case "arrowhead": 
                            case "arrowtail": {
                                this.provideHighlightingForArrowTypeString(node, acceptor);
                            }
                        }
                    }
                }
            }
            if (r.getName().equals("EdgeOp")) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"edge_op"});
            }
            if (!r.getName().equals("HTML_STRING")) continue;
            this.provideHighlightingForHtmlString(node, acceptor);
        }
    }

    private void provideHighlightingForArrowTypeString(INode node, IHighlightedPositionAcceptor acceptor) {
        String arrowTypeString = node.getText();
        int offset = node.getOffset();
        String suffix = null;
        if (arrowTypeString.length() > 0 && arrowTypeString.charAt(0) == '\"') {
            arrowTypeString = arrowTypeString.substring(1, arrowTypeString.length() - 1);
            ++offset;
            suffix = "_quoted";
        }
        DotSubgrammarHighlighter arrowTypeHighlighter = new DotSubgrammarHighlighter("org.eclipse.gef.dot.internal.language.DotArrowType");
        arrowTypeHighlighter.provideHightlightingFor(arrowTypeString, offset, acceptor, suffix);
    }

    private void provideHighlightingForHtmlString(INode node, IHighlightedPositionAcceptor acceptor) {
        int openingSymbolOffset = node.getOffset();
        acceptor.addPosition(openingSymbolOffset, 1, new String[]{"html_tag"});
        int closingSymbolOffset = node.getOffset() + node.getText().length() - 1;
        acceptor.addPosition(closingSymbolOffset, 1, new String[]{"html_tag"});
        String htmlString = node.getText().substring(1, node.getText().length() - 1);
        DotSubgrammarHighlighter htmlLabelHighlighter = new DotSubgrammarHighlighter("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
        htmlLabelHighlighter.provideHightlightingFor(htmlString, node.getOffset() + 1, acceptor);
    }
}

