/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkConnection;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.jpa2.persistence.JptJpaUiPersistenceMessages2_0;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class EclipseLinkJdbcConnectionPropertiesComposite<T extends EclipseLinkConnection>
extends Pane<T> {
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.jpa.eclipselink.ui.dialogs.ConnectionDialog";

    public EclipseLinkJdbcConnectionPropertiesComposite(Pane<T> parent, Composite parentComposite) {
        super(parent, parentComposite);
    }

    private ModifiablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, String>(this.getSubjectHolder(), new String[]{"password"}){

            protected String buildValue_() {
                return ((EclipseLinkConnection)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((EclipseLinkConnection)this.subject).setPassword(value);
            }
        };
    }

    private Runnable buildPopulateFromConnectionAction() {
        return new Runnable(){

            @Override
            public void run() {
                EclipseLinkJdbcConnectionPropertiesComposite.this.promptConnection();
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, String>(this.getSubjectHolder(), new String[]{"url"}){

            protected String buildValue_() {
                return ((EclipseLinkConnection)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((EclipseLinkConnection)this.subject).setUrl(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildUserHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, String>(this.getSubjectHolder(), new String[]{"user"}){

            protected String buildValue_() {
                return ((EclipseLinkConnection)this.subject).getUser();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((EclipseLinkConnection)this.subject).setUser(value);
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        Hyperlink hyperLink = this.addHyperlink(container, JptJpaUiPersistenceMessages2_0.JDBC_CONNECTION_PROPERTIES_COMPOSITE_POPULATE_FROM_CONNECTION_HYPER_LINK, this.buildPopulateFromConnectionAction());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        hyperLink.setLayoutData((Object)gridData);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_DRIVER_LABEL);
        this.initializeJdbcDriverClassChooser(container);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_URL_LABEL);
        this.addText(container, this.buildUrlHolder());
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_USER_LABEL);
        this.addText(container, this.buildUserHolder());
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_PASSWORD_LABEL);
        this.addPasswordText(container, this.buildPasswordHolder());
        TriStateCheckBox bindParametersCheckBox = this.addTriStateCheckBoxWithDefault(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_BIND_PARAMETERS_LABEL, this.buildBindParametersHolder(), this.buildBindParametersStringHolder(), JpaHelpContextIds.PERSISTENCE_XML_CONNECTION);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        bindParametersCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private ClassChooserPane<EclipseLinkConnection> initializeJdbcDriverClassChooser(Composite container) {
        return new ClassChooserPane<EclipseLinkConnection>((Pane)this, container){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkConnection, String>(this.getSubjectHolder(), new String[]{"driver"}){

                    protected String buildValue_() {
                        return ((EclipseLinkConnection)this.subject).getDriver();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((EclipseLinkConnection)this.subject).setDriver(value);
                    }
                };
            }

            protected String getClassName() {
                return ((EclipseLinkConnection)this.getSubject()).getDriver();
            }

            protected IJavaProject getJavaProject() {
                return ((EclipseLinkConnection)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((EclipseLinkConnection)this.getSubject()).setDriver(className);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildBindParametersHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, Boolean>(this.getSubjectHolder(), new String[]{"bindParameters"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkConnection)this.subject).getBindParameters();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkConnection)this.subject).setBindParameters(value);
            }
        };
    }

    private PropertyValueModel<String> buildBindParametersStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultBindParametersHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_BIND_PARAMETERS_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_BIND_PARAMETERS_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultBindParametersHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, Boolean>(this.getSubjectHolder(), new String[]{"bindParameters"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkConnection)this.subject).getBindParameters() != null) {
                    return null;
                }
                return ((EclipseLinkConnection)this.subject).getDefaultBindParameters();
            }
        };
    }

    void promptConnection() {
        ConnectionSelectionDialog dialog = new ConnectionSelectionDialog();
        if (dialog.open() != 0) {
            return;
        }
        String name = (String)dialog.getResult()[0];
        ConnectionProfileFactory factory = this.getConnectionProfileFactory();
        ConnectionProfile cp = factory == null ? null : factory.buildConnectionProfile(name);
        EclipseLinkConnection connection = (EclipseLinkConnection)this.getSubject();
        connection.setUrl(cp == null ? "" : cp.getURL());
        connection.setUser(cp == null ? "" : cp.getUserName());
        connection.setPassword(cp == null ? "" : cp.getUserPassword());
        connection.setDriver(cp == null ? "" : cp.getDriverClassName());
    }

    ConnectionProfileFactory getConnectionProfileFactory() {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getConnectionProfileFactory();
    }

    private JpaWorkspace getJpaWorkspace() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench == null ? null : jpaWorkbench.getJpaWorkspace();
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }

    Shell getShell_() {
        return this.getShell();
    }

    protected class ConnectionSelectionDialog
    extends FilteredItemsSelectionDialog {
        protected ConnectionSelectionDialog() {
            super(EclipseLinkJdbcConnectionPropertiesComposite.this.getShell_(), false);
            this.setMessage(JptJpaEclipseLinkUiMessages.JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_MESSAGE);
            this.setTitle(JptJpaEclipseLinkUiMessages.JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_TITLE);
            this.setListLabelProvider(this.buildLabelProvider());
            this.setDetailsLabelProvider(this.buildLabelProvider());
        }

        protected ILabelProvider buildLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new ConnectionItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            Iterable<String> profileNames = this.getConnectionProfileNames();
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)IterableTools.size(profileNames));
            for (String name : profileNames) {
                provider.add((Object)name, itemsFilter);
                sm.worked(1);
            }
        }

        private Iterable<String> getConnectionProfileNames() {
            ConnectionProfileFactory factory = EclipseLinkJdbcConnectionPropertiesComposite.this.getConnectionProfileFactory();
            return factory == null ? IterableTools.emptyIterable() : factory.getConnectionProfileNames();
        }

        protected IDialogSettings getDialogSettings() {
            return JptJpaEclipseLinkUiPlugin.instance().getDialogSettings(EclipseLinkJdbcConnectionPropertiesComposite.DIALOG_SETTINGS);
        }

        public String getElementName(Object object) {
            return object.toString();
        }

        protected Comparator<String> getItemsComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    return item1.compareTo(item2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            return item == null ? JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus() : Status.OK_STATUS;
        }

        private class ConnectionItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            ConnectionItemsFilter() {
                super((FilteredItemsSelectionDialog)ConnectionSelectionDialog.this);
                if (StringTools.isBlank((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                return this.matches(item.toString());
            }
        }
    }
}

