/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.felix.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.ProgressUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.felix.FelixFrameworkInstance;
import org.eclipse.libra.framework.felix.IFelixFrameworkInstance;
import org.eclipse.libra.framework.felix.IFelixVersionHandler;
import org.eclipse.libra.framework.felix.Messages;
import org.eclipse.libra.framework.felix.internal.FelixConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;

public class FelixRuntimeInstanceBehavior
extends OSGIFrameworkInstanceBehaviorDelegate {
    protected transient FelixConfigurationPublishHelper publishHelper = new FelixConfigurationPublishHelper(this);

    public IFelixVersionHandler getFelixVersionHandler() {
        return this.getFelixRuntimeInstance().getFelixVersionHandler();
    }

    public FelixFrameworkInstance getFelixRuntimeInstance() {
        return (FelixFrameworkInstance)this.getServer().loadAdapter(FelixFrameworkInstance.class, null);
    }

    public String getFrameworkClass() {
        return this.getFelixVersionHandler().getFrameworkClass();
    }

    public String[] getFrameworkProgramArguments(boolean starting) {
        return this.getFelixVersionHandler().getFrameworkProgramArguments(this.getBaseDirectory(), this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getExcludedFrameworkProgramArguments(boolean starting) {
        return this.getFelixVersionHandler().getExcludedFrameworkProgramArguments(this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getFrameworkVMArguments() {
        IPath deployPath;
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        if (!(deployPath = this.getBaseDirectory()).isAbsolute()) {
            try {
                String deployLoc = new File(deployPath.toOSString()).getCanonicalPath();
                deployPath = new Path(deployLoc);
            }
            catch (IOException iOException) {}
        }
        int jmxPort = ((IFelixFrameworkInstance)this.getFrameworkInstance()).getJMXPort();
        boolean jmxEnabled = ((IFelixFrameworkInstance)this.getFrameworkInstance()).getJMXEnabled();
        return this.getFelixVersionHandler().getFrameworkVMArguments(installPath, null, deployPath, false, jmxEnabled, jmxPort);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath confDir = this.getBaseDirectory();
        IStatus status = this.getFelixVersionHandler().prepareDeployDirectory(confDir);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        IPath confDir = this.getBaseDirectory();
        try {
            FrameworkInstanceConfiguration felixConfiguration = this.getFelixRuntimeInstance().getFelixConfiguration();
            this.publishHelper.exportBundles(modules, felixConfiguration, confDir);
            this.getFelixVersionHandler().prepareFrameworkConfigurationFile(confDir, this.publishHelper.getServerModules(modules, "reference:file:", " "), this.publishHelper.getTargetBundles(felixConfiguration, "reference:file:", " "));
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Publishing failed", (Throwable)e);
        }
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        Properties p = this.loadModulePublishLocations();
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }
}

