/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.pom.PomTemplateContext;
import org.eclipse.m2e.editor.xml.AddLicensePomOperation;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.dialogs.SPDXLicense;
import org.eclipse.m2e.editor.xml.internal.dialogs.SelectSPDXLicenseDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertSPDXLicenseProposal
implements ICompletionProposal {
    private static final Logger log = LoggerFactory.getLogger(InsertSPDXLicenseProposal.class);
    private final ITextViewer sourceViewer;
    private final Region region;
    private final PomTemplateContext context;
    private Point selection;

    public InsertSPDXLicenseProposal(ITextViewer sourceViewer, PomTemplateContext context, Region region) {
        this.sourceViewer = sourceViewer;
        this.context = context;
        this.region = region;
    }

    public void apply(IDocument document) {
        IProject project = XmlUtils.extractProject((ITextViewer)this.sourceViewer);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        SelectSPDXLicenseDialog dialog = new SelectSPDXLicenseDialog(this.sourceViewer.getTextWidget().getShell(), facade);
        if (dialog.open() == 0) {
            SPDXLicense license = dialog.getLicense();
            try {
                IMavenProjectFacade targetProject = dialog.getTargetProject();
                if (!targetProject.getPom().equals((Object)facade.getPom())) {
                    AddLicensePomOperation operation = new AddLicensePomOperation(license, PomTemplateContext.PROJECT, null);
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(targetProject.getPom(), (PomEdits.Operation)operation)});
                } else {
                    AddLicensePomOperation operation = new AddLicensePomOperation(license, this.context, this.region);
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(document, (PomEdits.Operation)operation)});
                    this.selection = operation.getSelection();
                }
            }
            catch (CoreException e) {
                log.error("Failed inserting parent element", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Failed inserting parent element", (Throwable)e);
            }
        }
    }

    public Point getSelection(IDocument document) {
        return this.selection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return Messages.InsertSPDXLicenseProposal_0;
    }

    public Image getImage() {
        return MvnImages.IMG_LICENSE;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

