/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.internal.util.LaunchModelUtils;

public final class LaunchConfigUtils {
    private static final String ENCODING = "UTF-8";
    private static final String COULD_NOT_DESERIALIZE_MSG = "Could not deserialize discovery launch configuration";
    private static final String COULD_NOT_SERIALIZE_MSG = "Could not serialize discovery launch configuration";

    private LaunchConfigUtils() {
    }

    public static LaunchConfiguration getConfigurationModel(ILaunchConfiguration launchConfig) {
        LaunchConfiguration configurationModel = LaunchConfigUtils.loadConfigurationModel(launchConfig);
        if (configurationModel != null) {
            return configurationModel;
        }
        return LaunchModelUtils.createLaunchConfigurationModel();
    }

    public static LaunchConfiguration loadConfigurationModel(ILaunchConfiguration launchConfig) {
        String launchModelSerialized = null;
        try {
            launchModelSerialized = launchConfig.getAttribute("discoverer_launch_model", "");
            if (launchModelSerialized != null && launchModelSerialized.trim().length() > 0) {
                Resource launchResource = LaunchModelUtils.createLaunchResource();
                byte[] bytes = launchModelSerialized.getBytes(ENCODING);
                ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                launchResource.load((InputStream)input, null);
                if (launchResource.getContents().size() > 0) {
                    LaunchConfiguration launchConfiguration = (LaunchConfiguration)launchResource.getContents().get(0);
                    return launchConfiguration;
                }
                MoDiscoLogger.logWarning((String)"Could not deserialize discovery launch configuration : empty resource", (Plugin)Activator.getDefault());
            }
        }
        catch (UnsupportedEncodingException e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)COULD_NOT_DESERIALIZE_MSG, (Plugin)Activator.getDefault());
        }
        catch (CoreException e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)COULD_NOT_DESERIALIZE_MSG, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)COULD_NOT_DESERIALIZE_MSG, (Plugin)Activator.getDefault());
        }
        return null;
    }

    public static void saveConfigurationModel(LaunchConfiguration configurationModel, ILaunchConfigurationWorkingCopy launchConfig) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            configurationModel.eResource().save((OutputStream)outStream, null);
            String launchModelSerialized = new String(outStream.toByteArray(), ENCODING);
            launchConfig.setAttribute("discoverer_launch_model", launchModelSerialized);
        }
        catch (UnsupportedEncodingException e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)COULD_NOT_SERIALIZE_MSG, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)COULD_NOT_SERIALIZE_MSG, (Plugin)Activator.getDefault());
        }
    }
}

