/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class Worklist<T>
implements Iterable<T> {
    private final LinkedList<T> worklist = new LinkedList();
    private int size = 0;

    public Worklist() {
    }

    public Worklist(T item) {
        this.add(item);
    }

    public Worklist(T ... items) {
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            this.add(item);
            ++n2;
        }
    }

    public void clear() {
        this.worklist.clear();
        this.size = 0;
    }

    public void add(T item) {
        ++this.size;
        this.worklist.add(item);
    }

    public void addAll(Collection<T> items) {
        this.size += items.size();
        this.worklist.addAll(items);
    }

    public boolean contains(T item) {
        return this.worklist.contains(item);
    }

    public int size() {
        return this.size;
    }

    public T removeFirst() {
        --this.size;
        return this.worklist.removeFirst();
    }

    public boolean done() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !Worklist.this.done();
            }

            @Override
            public T next() {
                return Worklist.this.removeFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.worklist.toString();
    }
}

