/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.ptp.rm.lml.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LguiHandler;

public class ObjectStatus
extends LguiHandler {
    private ObjectType lastMouseOver;
    private ObjectType lastMouseDown;
    private HashMap<ObjectType, State> mapping = new HashMap();
    private final ArrayList<Updatable> components = new ArrayList();

    public ObjectStatus(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        lguiItem.addListener(new ILguiListener(){

            @Override
            public void handleEvent(ILguiUpdatedEvent e) {
                ObjectStatus.this.updateData(e.getLgui());
            }
        });
    }

    public void addComponent(Updatable up) {
        if (!this.components.contains(up)) {
            this.components.add(up);
        }
    }

    public ObjectType getLastMouseDown() {
        return this.lastMouseDown;
    }

    public ObjectType getLastMouseOver() {
        return this.lastMouseOver;
    }

    public boolean isAnyMouseDown() {
        return this.lastMouseDown != null;
    }

    public boolean isAnyMouseover() {
        return this.lastMouseOver != null;
    }

    public boolean isMouseDown(ObjectType obj) {
        if (obj == null) {
            return false;
        }
        if (this.mapping.containsKey(obj)) {
            return this.mapping.get((Object)obj).mouseDown;
        }
        this.mapping.put(obj, new State());
        return false;
    }

    public boolean isMouseOver(ObjectType obj) {
        if (obj == null) {
            return false;
        }
        if (this.mapping.containsKey(obj)) {
            return this.mapping.get((Object)obj).mouseOver;
        }
        this.mapping.put(obj, new State());
        return false;
    }

    public void mouseDown(ObjectType obj) {
        if (obj == null) {
            return;
        }
        if (!this.mapping.containsKey(obj)) {
            this.mapping.put(obj, new State());
        }
        State az = this.mapping.get(obj);
        if (!az.mouseDown) {
            az.mouseDown = true;
            this.lastMouseDown = obj;
            this.informAll(obj, az.mouseOver, true);
        }
    }

    public void mouseDown(String oid) {
        ObjectType object = this.lguiItem.getOIDToObject().getObjectById(oid);
        this.mouseDown(object);
    }

    public void mouseexit(ObjectType obj) {
        if (obj == null) {
            return;
        }
        if (!this.mapping.containsKey(obj)) {
            this.mapping.put(obj, new State());
        }
        State az = this.mapping.get(obj);
        if (az.mouseOver) {
            az.mouseOver = false;
            this.lastMouseOver = null;
            this.informAll(obj, false, az.mouseDown);
        }
    }

    public void mouseExit(String oid) {
        ObjectType object = this.lguiItem.getOIDToObject().getObjectById(oid);
        this.mouseexit(object);
    }

    public void mouseExitLast() {
        this.mouseexit(this.lastMouseOver);
        this.mouseUp(this.lastMouseDown);
    }

    public void mouseOver(ObjectType obj) {
        if (obj == null) {
            return;
        }
        if (obj == this.lastMouseOver) {
            return;
        }
        if (obj != this.lastMouseOver) {
            this.mouseExitLast();
        }
        if (obj != this.lastMouseDown) {
            this.mouseUp(this.lastMouseDown);
        }
        this.lastMouseOver = obj;
        this.justMouseover(obj);
    }

    public void mouseOver(String oid) {
        ObjectType object = this.lguiItem.getOIDToObject().getObjectById(oid);
        this.mouseOver(object);
    }

    public void mouseUp(ObjectType obj) {
        if (obj == null) {
            return;
        }
        if (this.lastMouseDown != obj) {
            this.mouseUp(this.lastMouseDown);
            this.mouseExitLast();
            this.mouseOver(obj);
        }
        if (!this.mapping.containsKey(obj)) {
            this.mapping.put(obj, new State());
        }
        State az = this.mapping.get(obj);
        if (az.mouseDown) {
            az.mouseDown = false;
            this.lastMouseDown = null;
            this.informAll(obj, az.mouseOver, false);
        }
    }

    public void mouseUp(String oid) {
        ObjectType object = this.lguiItem.getOIDToObject().getObjectById(oid);
        this.mouseUp(object);
    }

    public void removeComponent(Updatable up) {
        if (this.components.contains(up)) {
            this.components.remove(up);
        }
    }

    public void updateData(LguiType model) {
        this.reset();
    }

    private void informAll(ObjectType obj, boolean mouseover, boolean mousedown) {
        int i = 0;
        while (i < this.components.size()) {
            this.components.get(i).updateStatus(obj, mouseover, mousedown);
            ++i;
        }
    }

    private void justMouseover(ObjectType obj) {
        if (obj == null) {
            return;
        }
        if (!this.mapping.containsKey(obj)) {
            this.mapping.put(obj, new State());
        }
        State az = this.mapping.get(obj);
        if (!az.mouseOver) {
            az.mouseOver = true;
            this.informAll(obj, true, az.mouseDown);
        }
    }

    private void reset() {
        this.mapping = new HashMap();
        this.lastMouseOver = null;
        this.lastMouseDown = null;
    }

    private static class State {
        public boolean mouseDown = false;
        public boolean mouseOver = false;
    }

    public static interface Updatable {
        public void updateStatus(ObjectType var1, boolean var2, boolean var3);
    }
}

