/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.log.collector;

import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.direct.platform.Platform;
import org.eclipse.reddeer.junit.extension.log.collector.LogCollector;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class AftersLogCollector
extends LogCollector
implements IAfterTest {
    public static String AFTER_TEST_METHOD_DESCRIPTION = "Log entries collected between before extensions (included) and\nafter extensions (included) for test method:";
    public static final String AFTER_TEST_CLASS_DESCRIPTION = "Log entries collected between after extensions (excluded) \nand after class extensions (included):";

    public long getPriority() {
        return Long.MIN_VALUE;
    }

    public void runAfterTestClass(String config, TestClass testClass) {
        this.processWorkbenchLog(config, testClass.getJavaClass().getSimpleName(), AFTER_TEST_CLASS_DESCRIPTION);
        Platform.getWorkbenchLog().delete();
    }

    public void runAfterTest(String config, Object target, FrameworkMethod method) {
        this.constructAfterTestMethodDescription(method.getMethod().getName());
        this.processWorkbenchLog(config, method.getDeclaringClass().getSimpleName(), AFTER_TEST_METHOD_DESCRIPTION);
        Platform.getWorkbenchLog().delete();
    }

    public boolean hasToRun() {
        return RedDeerProperties.LOG_COLLECTOR_ENABLED.getBooleanValue() && this.eclipseLogFileExists();
    }

    private void constructAfterTestMethodDescription(String testMethodName) {
        AFTER_TEST_METHOD_DESCRIPTION = "Log entries collected between before extensions (included) and\nafter extensions (included) for test method " + testMethodName + ":";
    }
}

