/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tcf.internal.debug.model.ITCFBreakpointListener;
import org.eclipse.tcf.internal.debug.model.TCFBreakpoint;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsStatus;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.protocol.Protocol;

class TCFBreakpointStatusListener {
    private static final String ATTR_REFCOUNT = "org.eclipse.tcf.cdt.refcount";
    private final TCFModelManager.ModelManagerListener launch_listener = new TCFModelManager.ModelManagerListener(){

        public void onConnected(TCFLaunch launch, TCFModel model) {
            if (!$assertionsDisabled && TCFBreakpointStatusListener.this.bp_listeners.get(launch) != null) {
                throw new AssertionError();
            }
            if (launch.getBreakpointsStatus() != null) {
                new BreakpointListener(launch);
            }
        }

        public void onDisconnected(TCFLaunch launch, TCFModel model) {
            BreakpointListener l = (BreakpointListener)TCFBreakpointStatusListener.this.bp_listeners.remove(launch);
            if (l != null) {
                l.dispose();
            }
        }
    };
    private final TCFModelManager model_manager;
    private final TCFBreakpointsModel bp_model = TCFBreakpointsModel.getBreakpointsModel();
    private final Map<TCFLaunch, BreakpointListener> bp_listeners;

    TCFBreakpointStatusListener() {
        this.model_manager = TCFModelManager.getModelManager();
        this.model_manager.addListener(this.launch_listener);
        this.bp_listeners = new HashMap<TCFLaunch, BreakpointListener>();
        for (TCFModel model : this.model_manager.getModels()) {
            TCFLaunch launch = model.getLaunch();
            if (!launch.isConnected()) continue;
            this.launch_listener.onConnected(launch, model);
        }
    }

    void dispose() {
        this.model_manager.removeListener(this.launch_listener);
        for (BreakpointListener l : this.bp_listeners.values()) {
            l.dispose();
        }
        this.bp_listeners.clear();
    }

    private class BreakpointListener
    implements ITCFBreakpointListener,
    IBreakpointListener {
        private final TCFBreakpointsStatus status;
        private final Map<String, ICBreakpoint> installed = new HashMap<String, ICBreakpoint>();
        private final Set<String> foreign = new HashSet<String>();
        private final Set<String> deleted = new HashSet<String>();

        BreakpointListener(TCFLaunch launch) {
            this.status = launch.getBreakpointsStatus();
            this.status.addListener((ITCFBreakpointListener)this);
            TCFBreakpointStatusListener.this.bp_listeners.put(launch, this);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            for (String id : this.status.getStatusIDs()) {
                this.breakpointStatusChanged(id);
            }
        }

        public void breakpointStatusChanged(String id) {
            IBreakpoint bp = TCFBreakpointStatusListener.this.bp_model.getBreakpoint(id);
            this.updateStatus(id, bp);
            if (bp == null) {
                this.createOrUpdateBreakpoint(id);
            }
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            this.updateBreakpoint(breakpoint, false);
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
            this.updateBreakpoint(breakpoint, true);
        }

        private void updateBreakpoint(IBreakpoint breakpoint, final boolean removed) {
            try {
                IMarker marker = breakpoint.getMarker();
                if (marker == null || !marker.exists()) {
                    return;
                }
                if (TCFBreakpointsModel.isLocal((IMarker)marker)) {
                    return;
                }
                final String marker_id = TCFBreakpointsModel.getBreakpointID((IBreakpoint)breakpoint);
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (removed) {
                            BreakpointListener.this.foreign.remove(marker_id);
                        }
                        BreakpointListener.this.createOrUpdateBreakpoint(marker_id);
                    }
                });
            }
            catch (CoreException coreException) {}
        }

        private void updateStatus(String id, IBreakpoint bp) {
            if (bp instanceof ICBreakpoint) {
                Collection list;
                boolean ok = false;
                ICBreakpoint cbp = (ICBreakpoint)bp;
                Map map = this.status.getStatus(id);
                if (map != null && (list = (Collection)map.get("Instances")) != null) {
                    for (Map m : list) {
                        if (m.get("Error") != null) continue;
                        ok = true;
                    }
                }
                if (ok && this.installed.get(id) == null) {
                    this.installed.put(id, cbp);
                    this.incrementInstallCount(cbp);
                } else if (!ok && this.installed.get(id) == cbp) {
                    this.installed.remove(id);
                    this.decrementInstallCount(cbp);
                } else {
                    this.updateTCFStamp(cbp);
                }
            } else if (bp instanceof TCFBreakpoint) {
                this.updateStatus((TCFBreakpoint)bp);
            }
        }

        public void breakpointRemoved(String id) {
            ICBreakpoint cbp = this.installed.remove(id);
            if (cbp != null) {
                this.decrementInstallCount(cbp);
            }
            if (this.foreign.remove(id)) {
                this.deleteTransientBreakpoint(id);
            }
        }

        public void breakpointChanged(String id) {
            this.createOrUpdateBreakpoint(id);
        }

        void dispose() {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            for (ICBreakpoint cbp : this.installed.values()) {
                this.decrementInstallCount(cbp);
            }
            this.installed.clear();
            for (String id : this.foreign) {
                this.deleteTransientBreakpoint(id);
            }
            this.foreign.clear();
        }

        private void incrementInstallCount(final ICBreakpoint cbp) {
            WorkspaceJob job = new WorkspaceJob("Increment Breakpoint Install Count"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        cbp.incrementInstallCount();
                        BreakpointListener.this.doUpdateTCFStamp(cbp);
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)cbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void decrementInstallCount(final ICBreakpoint cbp) {
            WorkspaceJob job = new WorkspaceJob("Decrement Breakpoint Install Count"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        cbp.decrementInstallCount();
                        BreakpointListener.this.doUpdateTCFStamp(cbp);
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)cbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void updateTCFStamp(final ICBreakpoint cbp) {
            WorkspaceJob job = new WorkspaceJob("Update C Breakpoint"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        BreakpointListener.this.doUpdateTCFStamp(cbp);
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)cbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void doUpdateTCFStamp(ICBreakpoint cbp) throws CoreException {
            IMarker marker = cbp.getMarker();
            if (marker != null && marker.exists()) {
                marker.setAttribute("org.eclipse.tcf.debug.tcfStamp", (Object)"true");
            }
        }

        private void updateStatus(final TCFBreakpoint tbp) {
            WorkspaceJob job = new WorkspaceJob("Update Breakpoint Status"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        tbp.notifyStatusChaged();
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)tbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void createOrUpdateBreakpoint(final String id) {
            if (id.startsWith("Step.")) {
                return;
            }
            Map properties = this.status.getProperties(id);
            if (properties == null) {
                return;
            }
            if (TCFBreakpointsModel.isLocal((Map)properties)) {
                return;
            }
            final boolean create = this.foreign.add(id);
            final Map markerAttrs = TCFBreakpointStatusListener.this.bp_model.toMarkerAttributes(properties);
            markerAttrs.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
            markerAttrs.put("transient", Boolean.TRUE);
            WorkspaceJob job = new WorkspaceJob("Create Breakpoint Marker"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    Object bp;
                    IBreakpoint[] bps;
                    if (BreakpointListener.this.deleted.remove(id)) {
                        return Status.OK_STATUS;
                    }
                    IBreakpoint[] iBreakpointArray = bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        bp = iBreakpointArray[n2];
                        IMarker marker = bp.getMarker();
                        if (marker != null && id.equals(TCFBreakpointsModel.getBreakpointID((IBreakpoint)bp))) {
                            if (create) {
                                int cnt = marker.getAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, 0) + 1;
                                marker.setAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, cnt);
                            } else {
                                markerAttrs.remove("org.eclipse.cdt.debug.core.sourceHandle");
                                this.updateMarkerAttributes(markerAttrs, marker);
                            }
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                    if (!create) {
                        return Status.OK_STATUS;
                    }
                    markerAttrs.put(TCFBreakpointStatusListener.ATTR_REFCOUNT, 1);
                    IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                    bp = markerAttrs.get("org.eclipse.cdt.debug.core.expression") != null ? new CWatchpoint((IResource)resource, markerAttrs, true) : (markerAttrs.get("org.eclipse.cdt.debug.core.address") != null ? new CAddressBreakpoint((IResource)resource, markerAttrs, true) : (markerAttrs.get("org.eclipse.cdt.debug.core.function") != null ? new CFunctionBreakpoint((IResource)resource, markerAttrs, true) : (markerAttrs.get("org.eclipse.cdt.debug.core.sourceHandle") != null && markerAttrs.get("lineNumber") != null ? new CLineBreakpoint((IResource)resource, markerAttrs, true) : TCFBreakpoint.createFromMarkerAttributes((Map)markerAttrs))));
                    Protocol.invokeLater((Runnable)new Runnable((IBreakpoint)bp){
                        private final /* synthetic */ IBreakpoint val$bp;
                        {
                            this.val$bp = iBreakpoint;
                        }

                        @Override
                        public void run() {
                            BreakpointListener.this.updateStatus(id, this.val$bp);
                        }
                    });
                    return Status.OK_STATUS;
                }

                private void updateMarkerAttributes(Map<String, Object> markerAttrs2, IMarker marker) throws CoreException {
                    ArrayList<String> keys = new ArrayList<String>(markerAttrs2.size());
                    ArrayList<Object> values = new ArrayList<Object>(markerAttrs2.size());
                    Map oldAttrs = marker.getAttributes();
                    for (Map.Entry<String, Object> entry : markerAttrs2.entrySet()) {
                        String key = entry.getKey();
                        Object newVal = entry.getValue();
                        Object oldVal = oldAttrs.remove(key);
                        if (oldVal != null && oldVal.equals(newVal)) continue;
                        keys.add(key);
                        values.add(newVal);
                    }
                    if (keys.size() != 0) {
                        String[] keyArr = keys.toArray(new String[keys.size()]);
                        Object[] valueArr = values.toArray(new Object[values.size()]);
                        marker.setAttributes(keyArr, valueArr);
                    }
                }
            };
            job.setRule(this.getBreakpointAccessRule());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void deleteTransientBreakpoint(final String id) {
            WorkspaceJob job = new WorkspaceJob("Destroy Breakpoint Marker"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IBreakpoint[] bps;
                    IBreakpoint[] iBreakpointArray = bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker;
                        IBreakpoint bp = iBreakpointArray[n2];
                        if (!bp.isPersisted() && (marker = bp.getMarker()) != null && id.equals(marker.getAttribute("org.eclipse.tcf.debug.ID", null))) {
                            int cnt = marker.getAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, 0) - 1;
                            if (cnt > 0) {
                                marker.setAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, cnt);
                            } else {
                                bp.delete();
                            }
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                    BreakpointListener.this.deleted.add(id);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(this.getBreakpointAccessRule());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private ISchedulingRule getBreakpointAccessRule() {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
            if (rule == null) {
                rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)resource);
            }
            return rule;
        }
    }
}

