/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.preferences.bind.AbstractBindingPreferencesPage;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public abstract class LayoutsPreferencePage
extends AbstractBindingPreferencesPage {
    public LayoutsPreferencePage(ToolkitDescription toolkit) {
        super(toolkit);
    }

    protected AbstractBindingComposite createBindingComposite(Composite parent) {
        return new ContentsComposite(parent, this.m_bindManager, this.m_preferences);
    }

    protected class ContentsComposite
    extends AbstractBindingComposite {
        public ContentsComposite(Composite parent, DataBindManager bindManager, IPreferenceStore preferences) {
            super(parent, bindManager, preferences);
            GridLayoutFactory.create((Composite)this).noMargins().columns(2);
            new Label((Composite)this, 0).setText(UiMessages.LayoutsPreferencePage_defaultLayout);
            final Combo layoutCombo = new Combo((Composite)this, 8);
            GridDataFactory.create((Control)layoutCombo).grabH().fillH();
            UiUtils.setVisibleItemCount((Combo)layoutCombo, (int)15);
            final List layouts = LayoutDescriptionHelper.get((ToolkitDescription)LayoutsPreferencePage.this.m_toolkit);
            Collections.sort(layouts, new Comparator<LayoutDescription>(){

                @Override
                public int compare(LayoutDescription layout_1, LayoutDescription layout_2) {
                    return layout_1.getName().compareTo(layout_2.getName());
                }
            });
            layoutCombo.add(UiMessages.LayoutsPreferencePage_implicitLayout);
            for (LayoutDescription layoutDescription : layouts) {
                layoutCombo.add(layoutDescription.getName());
            }
            this.m_bindManager.bind(new IDataEditor(){

                public void setValue(Object value) {
                    String id = (String)value;
                    if (StringUtils.isEmpty((String)id)) {
                        layoutCombo.select(0);
                        return;
                    }
                    int index = 0;
                    while (index < layouts.size()) {
                        LayoutDescription layout = (LayoutDescription)layouts.get(index);
                        if (layout.getId().equals(id)) {
                            layoutCombo.select(1 + index);
                        }
                        ++index;
                    }
                }

                public Object getValue() {
                    int index = layoutCombo.getSelectionIndex();
                    if (index <= 0) {
                        return null;
                    }
                    LayoutDescription layout = (LayoutDescription)layouts.get(index - 1);
                    return layout.getId();
                }
            }, (IDataProvider)new StringPreferenceProvider(this.m_preferences, "layout.default"), true);
            this.checkButton((Composite)this, 2, UiMessages.LayoutsPreferencePage_inheritLayout, "layout.inheritLayoutOfParent");
        }
    }
}

