/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.properties;

import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.ObjectPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.parser.DatabindingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectPropertyInfo
extends PropertyInfo {
    public ObjectPropertyInfo(IGenericType sourceObjectType) {
        super(sourceObjectType, sourceObjectType);
    }

    @Override
    public ObserveInfo getObserveProperty(ObserveInfo observeObject) throws Exception {
        for (IObserveInfo observe : observeObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable)) {
            if (!(observe instanceof ObjectPropertyObserveInfo)) continue;
            return (ObserveInfo)observe;
        }
        return null;
    }

    @Override
    public boolean canShared(PropertyInfo property) {
        if (property instanceof ObjectPropertyInfo) {
            return !DatabindingParser.useGenerics || this.m_sourceObjectType.getFullTypeName().equals(property.getSourceObjectType().getFullTypeName());
        }
        return false;
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        if (this.getVariableIdentifier() == null) {
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{this.m_sourceObjectType.getSimpleTypeName(), "ObjectProperty"}));
        }
        if (generationSupport.useGenerics()) {
            lines.add("org.jdesktop.beansbinding.ObjectProperty" + GenericUtils.getTypesSource(this.m_sourceObjectType) + " " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.ObjectProperty.create();");
        } else {
            lines.add("org.jdesktop.beansbinding.Property " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.ObjectProperty.create();");
        }
    }

    @Override
    public String getPresentationText(IObserveInfo observeObject, IObserveInfo observeProperty, boolean full) throws Exception {
        return observeObject.getPresentation().getTextForBinding();
    }
}

