"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AstConverter = void 0;
const eslint_1 = require("eslint");
const analyze_scope_1 = require("@typescript-eslint/parser/dist/analyze-scope");
const visitor_keys_1 = require("@typescript-eslint/typescript-estree/dist/visitor-keys");
const TsEstree = __importStar(require("@typescript-eslint/typescript-estree/dist/ast-converter"));
function validateBoolean(value, fallback = false) {
    if (typeof value !== "boolean") {
        return fallback;
    }
    return value;
}
function createExtra(code) {
    const base = {
        debugLevel: new Set(),
        tokens: null,
        range: true,
        loc: true,
        comment: false,
        comments: [],
        strict: false,
        jsx: false,
        useJSXTextNode: false,
        log: () => { },
        projects: [],
        errorOnUnknownASTType: false,
        errorOnTypeScriptSyntacticAndSemanticIssues: false,
        code: "",
        tsconfigRootDir: process.cwd(),
        extraFileExtensions: [],
        preserveNodeMaps: undefined,
        createDefaultProgram: false,
        filePath: "",
    };
    return Object.assign(Object.assign({}, base), { code, tokens: [], loc: true, comment: true, comments: [] });
}
function applyParserOptionsToExtra(extra, options) {
    extra.range = typeof options.range === "boolean" ? options.range : extra.range;
    extra.loc = typeof options.loc === "boolean" ? options.loc : extra.range;
    /**
     * Track tokens in the AST
     */
    if (typeof options.tokens === "boolean" && options.tokens) {
        extra.tokens = [];
    }
    /**
     * Track comments in the AST
     */
    if (typeof options.comment === "boolean" && options.comment) {
        extra.comment = true;
        extra.comments = [];
    }
    /**
     * Enable JSX - note the applicable file extension is still required
     */
    if (typeof options.jsx === "boolean" && options.jsx) {
        extra.jsx = true;
    }
    /**
     * The JSX AST changed the node type for string literals
     * inside a JSX Element from `Literal` to `JSXText`.
     *
     * When value is `true`, these nodes will be parsed as type `JSXText`.
     * When value is `false`, these nodes will be parsed as type `Literal`.
     */
    if (typeof options.useJSXTextNode === "boolean" && options.useJSXTextNode) {
        extra.useJSXTextNode = true;
    }
    /**
     * Allow the user to cause the parser to error if it encounters an unknown AST Node Type
     * (used in testing)
     */
    if (typeof options.errorOnUnknownASTType === "boolean" && options.errorOnUnknownASTType) {
        extra.errorOnUnknownASTType = true;
    }
    /**
     * Allow the user to override the function used for logging
     */
    if (typeof options.loggerFn === "function") {
        extra.log = options.loggerFn;
    }
    else if (options.loggerFn === false) {
        extra.log = Function.prototype;
    }
    if (typeof options.project === "string") {
        extra.projects = [options.project];
    }
    else if (Array.isArray(options.project) && options.project.every(projectPath => typeof projectPath === "string")) {
        extra.projects = options.project;
    }
    if (typeof options.tsconfigRootDir === "string") {
        extra.tsconfigRootDir = options.tsconfigRootDir;
    }
    if (Array.isArray(options.extraFileExtensions) && options.extraFileExtensions.every(ext => typeof ext === "string")) {
        extra.extraFileExtensions = options.extraFileExtensions;
    }
    /**
     * Allow the user to enable or disable the preservation of the AST node maps
     * during the conversion process.
     *
     * NOTE: For backwards compatibility we also preserve node maps in the case where `project` is set,
     * and `preserveNodeMaps` is not explicitly set to anything.
     */
    extra.preserveNodeMaps = typeof options.preserveNodeMaps === "boolean" && options.preserveNodeMaps;
    if (options.preserveNodeMaps === undefined && extra.projects.length > 0) {
        extra.preserveNodeMaps = true;
    }
    return extra;
}
class AstConverter {
    constructor({ getProgram }) {
        this.getProgram = getProgram;
    }
    /**
     *
     * see also https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/typescript-estree/src/parser.ts#L346
     *
     */
    parseAndGenerateServices(src, options) {
        const code = src.getFullText();
        let extra = createExtra(code);
        extra.code = code;
        /**
         * Apply the given parser options
         */
        if (typeof options !== "undefined") {
            extra = applyParserOptionsToExtra(extra, options);
            if (typeof options.errorOnTypeScriptSyntacticAndSemanticIssues === "boolean" &&
                options.errorOnTypeScriptSyntacticAndSemanticIssues) {
                extra.errorOnTypeScriptSyntacticAndSemanticIssues = true;
            }
        }
        const shouldProvideParserServices = extra.projects && extra.projects.length > 0;
        // Note: astConverter is an internal API
        const convert = TsEstree.astConverter;
        const { estree, astMaps } = convert(src, extra, true);
        /**
         * Return the converted AST and additional parser services
         */
        const ret = {
            ast: estree,
            services: {
                program: this.getProgram(),
                hasFullTypeInformation: shouldProvideParserServices,
                esTreeNodeToTSNodeMap: astMaps.esTreeNodeToTSNodeMap,
                tsNodeToESTreeNodeMap: astMaps.tsNodeToESTreeNodeMap,
            },
        };
        return ret;
    }
    /**
     * See also https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/parser/src/parser.ts
     */
    parseForESLint(src, options) {
        try {
            if (!options || typeof options !== "object") {
                options = {};
            }
            if (options.sourceType !== "module" && options.sourceType !== "script") {
                options.sourceType = "script";
            }
            if (typeof options.ecmaFeatures !== "object") {
                options.ecmaFeatures = {};
            }
            const parserOptions = {};
            Object.assign(parserOptions, options, {
                useJSXTextNode: validateBoolean(options.useJSXTextNode, true),
                jsx: validateBoolean(options.ecmaFeatures.jsx),
            });
            if (typeof options.filePath === "string") {
                const tsx = options.filePath.endsWith(".tsx");
                if (tsx || options.filePath.endsWith(".ts")) {
                    parserOptions.jsx = tsx;
                }
            }
            /**
             * Allow the user to suppress the warning from typescript-estree if they are using an unsupported
             * version of TypeScript
             */
            const warnOnUnsupportedTypeScriptVersion = validateBoolean(options.warnOnUnsupportedTypeScriptVersion, true);
            if (!warnOnUnsupportedTypeScriptVersion) {
                parserOptions.loggerFn = false;
            }
            const { ast, services } = this.parseAndGenerateServices(src, parserOptions);
            ast.sourceType = options.sourceType;
            const scopeManager = analyze_scope_1.analyzeScope(ast, parserOptions);
            return {
                ast: ast,
                scopeManager: scopeManager,
                services,
                visitorKeys: visitor_keys_1.visitorKeys,
            };
        }
        catch (error) {
            throw error;
        }
    }
    convertToESLintSourceCode(src, options) {
        const code = src.getFullText();
        const { ast, scopeManager, services, visitorKeys } = this.parseForESLint(src, options);
        return new eslint_1.SourceCode({
            text: code,
            ast,
            scopeManager,
            parserServices: services,
            visitorKeys,
        });
    }
}
exports.AstConverter = AstConverter;
//# sourceMappingURL=ast-converter.js.map