import ts from "typescript";
import { Linter } from "eslint";
import { AstConverter } from "./ast-converter";
import { ConfigProvider } from "./eslint-config-provider";
export declare function translateToDiagnosticsFromESLintResult(result: Linter.LintMessage[], sourceFile: ts.SourceFile): ts.Diagnostic[];
export declare function isIntersect(message: Linter.LintMessage, range: {
    start: number;
    end: number;
}, sourceFile: ts.SourceFile): boolean;
export declare function translateToCodeFixesFromESLintResult(result: Linter.LintMessage[], fileName: string): ts.CodeFixAction[];
export declare type ESLintAdapterOptions = {
    logger: (msg: string) => void;
    getSourceFile: (fileName: string) => ts.SourceFile | undefined;
    converter: AstConverter;
    configProvider: ConfigProvider;
};
export declare class ESLintAdapter {
    private readonly linter;
    private readonly logger;
    private readonly converter;
    private readonly configProvider;
    private readonly getSourceFile;
    constructor({ logger, converter, configProvider, getSourceFile }: ESLintAdapterOptions);
    private getESLintResult;
    getSemanticDiagnostics(delegate: ts.LanguageService["getSemanticDiagnostics"], fileName: string): ReturnType<ts.LanguageService["getSemanticDiagnostics"]>;
    getCodeFixesAtPosition(delegate: ts.LanguageService["getCodeFixesAtPosition"], fileName: string, start: number, end: number, errorCodes: number[], formatOptions: ts.FormatCodeSettings, preferences: ts.UserPreferences): ReturnType<ts.LanguageService["getCodeFixesAtPosition"]>;
}
