"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode_languageserver_1 = require("vscode-languageserver");
const yamlLanguageService_1 = require("../src/languageservice/yamlLanguageService");
const testHelper_1 = require("./utils/testHelper");
const assert = require("assert");
const path = require("path");
const languageService = yamlLanguageService_1.getLanguageService(testHelper_1.schemaRequestService, testHelper_1.workspaceContext, [], null);
const languageSettings = {
    schemas: [],
    completion: true
};
const uri = testHelper_1.toFsPath(path.join(__dirname, './fixtures/testRequiredProperties.json'));
const fileMatch = ['*.yml', '*.yaml'];
languageSettings.schemas.push({ uri, fileMatch: fileMatch });
languageService.configure(languageSettings);
suite('Auto Completion Tests for required properties', () => {
    describe('yamlCompletion with required properties', function () {
        describe('doComplete', function () {
            function setup(content) {
                return vscode_languageserver_1.TextDocument.create('file://~/Desktop/vscode-k8s/test.yaml', 'yaml', 0, content);
            }
            function parseSetup(content, position) {
                const testTextDocument = setup(content);
                return languageService.doComplete(testTextDocument, testTextDocument.positionAt(position), false);
            }
            it('Insert required attributes at correct level', done => {
                const content = '- top:\n    prop1: demo\n- ';
                const completion = parseSetup(content, content.length);
                completion.then(function (result) {
                    const insertText = result.items[0].insertText;
                    assert.equal(insertText, 'top:\n  \tprop1: $1');
                }).then(done, done);
            });
            it('Insert required attributes at correct level even on first element', done => {
                const content = '- ';
                const completion = parseSetup(content, content.length);
                completion.then(function (result) {
                    const insertText = result.items[0].insertText;
                    assert.equal(insertText, 'top:\n  \tprop1: $1');
                }).then(done, done);
            });
        });
    });
});
//# sourceMappingURL=autoCompletion.requiredproperties.test.js.map