/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.calendar;

import java.util.Date;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.calendar.CalendarControl;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class CalendarPopup {
    Date date;
    CalendarControl calendar;
    Shell popupShell;
    Shell shell;
    Rectangle bounds;
    int borderWidth;
    private Button todayButton;
    private Button noneButton;

    public static Date openCalendarPopup(Shell shell, Rectangle absoluteBounds, int borderWidth, Date initialDate) {
        return CalendarPopup.openCalendarPopup(shell, absoluteBounds, borderWidth, initialDate, null);
    }

    public static Date openCalendarPopup(Shell shell, Rectangle absoluteBounds, int borderWidth, Date initialDate, String timezone) {
        CalendarPopup popup = new CalendarPopup(shell, absoluteBounds, borderWidth, initialDate, timezone);
        popup.open();
        Display display = shell.getDisplay();
        while (!popup.popupShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        popup.dispose();
        return popup.date;
    }

    public static Date openCalendarPopup(Control anchor, Date initialDate) {
        Rectangle anchorBounds = anchor.getBounds();
        Point absolute = anchor.toDisplay(anchorBounds.x, anchorBounds.y);
        anchorBounds.x = absolute.x;
        anchorBounds.y = absolute.y;
        return CalendarPopup.openCalendarPopup(anchor.getShell(), anchorBounds, anchor.getBorderWidth(), initialDate);
    }

    private CalendarPopup(Shell shell, Rectangle bounds, int borderWidth, Date initialDate, String timezone) {
        this.shell = shell;
        this.bounds = bounds;
        this.borderWidth = borderWidth;
        this.date = initialDate;
        this.createShell();
        this.hookListeners();
        if (timezone != null) {
            this.calendar.setTimeZone(timezone);
        }
        this.calendar.setSelectedDate(initialDate);
    }

    private void createShell() {
        this.popupShell = new Shell(this.shell, 16384);
        this.popupShell.setBackground(this.shell.getDisplay().getSystemColor(25));
        GridLayout gl = new GridLayout(2, true);
        this.popupShell.setLayout((Layout)gl);
        this.calendar = new CalendarControl((Composite)this.popupShell);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.calendar.setLayoutData(gd);
        this.todayButton = new Button((Composite)this.popupShell, 8);
        this.todayButton.setText(Messages.CalendarPopup_todayButton_text);
        this.noneButton = new Button((Composite)this.popupShell, 8);
        this.noneButton.setText(Messages.CalendarPopup_noneButton_text);
        int width = this.calculateButtonWidthHint();
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.widthHint = width;
        this.todayButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.widthHint = width;
        this.noneButton.setLayoutData((Object)gd);
        this.popupShell.pack();
    }

    private void hookListeners() {
        this.popupShell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                e.widget.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell activeShell = Display.getCurrent().getActiveShell();
                        if (activeShell == null || activeShell != (this).CalendarPopup.this.popupShell) {
                            CalendarPopup.this.selectAndClose((this).CalendarPopup.this.date);
                        }
                    }
                });
            }
        });
        this.popupShell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        CalendarPopup.this.selectAndClose(CalendarPopup.this.date);
                        e.doit = false;
                    }
                }
            }
        });
        this.calendar.addMouseListener((MouseListener)new MouseAdapter(){
            private int index = -1;

            public void mouseDown(MouseEvent e) {
                this.index = CalendarPopup.this.calendar.getMatrixIndex(e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                if (this.index != -1 && this.index == CalendarPopup.this.calendar.getMatrixIndex(e.x, e.y)) {
                    CalendarPopup.this.selectAndClose(CalendarPopup.this.calendar.getSelectedDate());
                } else {
                    this.index = -1;
                }
            }
        });
        this.calendar.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    CalendarPopup.this.selectAndClose(CalendarPopup.this.calendar.getSelectedDate());
                }
            }
        });
        this.todayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPopup.this.selectAndClose(new Date());
            }
        });
        this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPopup.this.selectAndClose(null);
            }
        });
    }

    private int calculateButtonWidthHint() {
        Point todaySize = this.todayButton.computeSize(-1, -1);
        Point noneSize = this.noneButton.computeSize(-1, -1);
        return todaySize.x > noneSize.x ? todaySize.x : noneSize.x;
    }

    void selectAndClose(Date date) {
        this.date = date;
        this.close();
    }

    private void open() {
        this.calendar.setFocus();
        Monitor monitor = this.shell.getMonitor();
        Rectangle size = this.popupShell.getBounds();
        Rectangle monitorBounds = monitor.getBounds();
        Point location = new Point(this.bounds.x, this.bounds.y + this.bounds.height);
        location.x = location.x + size.width > monitorBounds.x + monitorBounds.width ? monitorBounds.x + monitorBounds.width - size.width : (location.x < monitorBounds.x ? monitorBounds.x : (location.x -= this.borderWidth));
        if (location.y + size.height > monitorBounds.y + monitorBounds.height) {
            location.y = location.y - size.height - this.bounds.height - this.borderWidth * 2;
        } else if (location.y < monitorBounds.y) {
            location.y = monitorBounds.y;
        }
        this.popupShell.setLocation(location.x, location.y);
        this.popupShell.open();
    }

    private void close() {
        if (this.popupShell == null || this.popupShell.isDisposed()) {
            return;
        }
        this.popupShell.setVisible(false);
        this.popupShell.dispose();
    }

    private void dispose() {
        if (this.calendar != null) {
            this.calendar.dispose();
            this.calendar = null;
        }
        if (this.popupShell != null) {
            this.popupShell.dispose();
            this.popupShell = null;
        }
    }
}

