/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.util.XSDUtil;
import org.eclipse.bpel.validator.EmfModelQuery;
import org.eclipse.bpel.validator.helpers.DOMNodeAdapter;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IFunctionMeta;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.NodeAttributeValueFilter;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.Selector;
import org.eclipse.bpel.validator.model.UndefinedNode;
import org.eclipse.bpel.validator.model.XNotImplemented;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelQueryImpl
implements IModelQuery {
    protected static final Selector mSelector = new Selector();
    protected EmfModelQuery emfModelQuery = new EmfModelQuery();
    static IModelQuery gModelQuery = null;
    static IModelQuery[] gaModelQuery = new IModelQuery[0];
    static ArrayList<IModelQuery> gModelQueryList = new ArrayList(8);

    @Override
    public String getDiagnostic(int index) {
        return this.emfModelQuery.getXSDComparer().getDiagnostic(index);
    }

    @Override
    public boolean hasSupport(int item, String value) {
        switch (item) {
            case 0: {
                return "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(value) || "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(value);
            }
            case 1: {
                return "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(value) || "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(value);
            }
            case 2: {
                return "http://www.w3.org/2001/XMLSchema".equals(value) || "http://schemas.xmlsoap.org/wsdl/".equals(value);
            }
            case 3: {
                return false;
            }
        }
        throw new XNotImplemented("Not implemented: hasSupport(item=" + item + ")");
    }

    @Override
    public boolean check(int test, INode n1, INode n2) {
        switch (test) {
            case 0: {
                Object v2;
                if (n1 == n2) {
                    return true;
                }
                if (n1 == null || n2 == null) {
                    return false;
                }
                Object v1 = n1.nodeValue();
                if (v1 == (v2 = n2.nodeValue())) {
                    return true;
                }
                if (v1 != null) {
                    return v1.equals(v2);
                }
                return false;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                if (n1 != null && n1.isResolved()) break;
                return false;
            }
            case 4: {
                if (n1 == null) {
                    return false;
                }
                return n1.isResolved();
            }
        }
        throw new XNotImplemented("Not implemented: check(test=" + test + ")");
    }

    @Override
    public IFunctionMeta lookupFunction(String language, String ns, String name) {
        return null;
    }

    protected INode lookupVariable(INode context, String name) {
        NodeAttributeValueFilter aFilterByName = new NodeAttributeValueFilter(IConstants.AT_NAME, name);
        NodeAttributeValueFilter aFilterByFaultVariable = new NodeAttributeValueFilter(IConstants.AT_FAULT_VARIABLE, name);
        NodeAttributeValueFilter aFilterByVariable = new NodeAttributeValueFilter(IConstants.AT_VARIABLE, name);
        NodeAttributeValueFilter aFilterByCounterName = new NodeAttributeValueFilter(IConstants.AT_COUNTER_NAME, name);
        NodeNameFilter nFilterForEach = new NodeNameFilter(IConstants.ND_FOR_EACH);
        while (context != null) {
            if (Filters.SCOPE_OR_PROCESS.select(context)) {
                INode var = mSelector.selectNode(context, IConstants.ND_VARIABLES, IConstants.ND_VARIABLE, aFilterByName);
                if (var != null) {
                    return var;
                }
                var = mSelector.selectNode(context, IConstants.ND_FAULT_HANDLERS, IConstants.ND_CATCH, aFilterByFaultVariable);
                if (var != null) {
                    return var;
                }
                var = mSelector.selectNode(context, IConstants.ND_EVENT_HANDLERS, IConstants.ND_ON_EVENT, aFilterByVariable);
                if (var != null) {
                    return var;
                }
                INode parent = mSelector.selectParent(context, nFilterForEach);
                if (parent != null && aFilterByCounterName.select(parent)) {
                    return parent;
                }
            }
            context = context.parentNode();
        }
        return null;
    }

    protected INode lookupPartnerLink(INode context, String name) {
        NodeAttributeValueFilter aFilter = new NodeAttributeValueFilter(IConstants.AT_NAME, name);
        while (context != null) {
            INode obj;
            if (Filters.SCOPE_OR_PROCESS.select(context) && (obj = mSelector.selectNode(context, IConstants.ND_PARTNER_LINKS, IConstants.ND_PARTNER_LINK, aFilter)) != null) {
                return obj;
            }
            context = context.parentNode();
        }
        return null;
    }

    protected INode lookupCorrelationSet(INode context, String name) {
        NodeAttributeValueFilter aFilter = new NodeAttributeValueFilter(IConstants.AT_NAME, name);
        while (context != null) {
            INode obj;
            if (Filters.SCOPE_OR_PROCESS.select(context) && (obj = mSelector.selectNode(context, IConstants.ND_CORRELATION_SETS, IConstants.ND_CORRELATION_SET, aFilter)) != null) {
                return obj;
            }
            context = context.parentNode();
        }
        return null;
    }

    public INode lookupLink(INode context, String name) {
        NodeAttributeValueFilter aFilter = new NodeAttributeValueFilter(IConstants.AT_NAME, name);
        while (context != null) {
            INode link;
            QName contextNodeName = context.nodeName();
            if (contextNodeName.equals(IConstants.ND_FLOW) && (link = mSelector.selectNode(context, IConstants.ND_LINKS, IConstants.ND_LINK, aFilter)) != null) {
                return link;
            }
            context = context.parentNode();
        }
        return null;
    }

    @Override
    public INode lookup(INode context, int what, String name) {
        if (ModelQueryImpl.isEmpty(name)) {
            return null;
        }
        if (name.indexOf(58) >= 0) {
            return this.lookup(context, what, this.createQName(context, name));
        }
        return this.lookup(context, what, new QName(name));
    }

    @Override
    public INode lookup(INode context, int what, QName qname) {
        String name = qname.getLocalPart();
        Object modelObject = null;
        INode result = null;
        switch (what) {
            case 1: {
                if (context.isResolved()) {
                    result = this.lookupVariable(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_VARIABLE, IConstants.AT_NAME, name);
                break;
            }
            case 3: {
                if (context.isResolved()) {
                    result = this.lookupLink(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_LINK, IConstants.AT_NAME, name);
                break;
            }
            case 5: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.ND_IMPORT, new Object[0]);
                break;
            }
            case 2: {
                if (context.isResolved()) {
                    result = this.lookupPartnerLink(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_PARTNER_LINK, IConstants.AT_NAME, name);
                break;
            }
            case 4: {
                if (context.isResolved()) {
                    result = this.lookupCorrelationSet(context, name);
                }
                if (result != null) break;
                result = new UndefinedNode(IConstants.ND_CORRELATION_SET, IConstants.AT_NAME, name);
                break;
            }
            case 10: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.PLNK_ND_PARTNER_LINK_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 11: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.PLNK_ND_PARTNER_LINK_TYPE, IConstants.AT_NAME, name);
                break;
            }
            case 6: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_OPERATION, IConstants.AT_NAME, name);
                break;
            }
            case 12: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_PORT_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 7: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_MESSAGE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 13: {
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.WSDL_ND_PART, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 8: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 9: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.AT_TYPE, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 14: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.VPROP_ND_PROPERTY, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 15: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 17: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, qname.getLocalPart());
                break;
            }
            case 16: {
                if (context.isResolved()) {
                    modelObject = null;
                }
                if (modelObject != null) break;
                result = new UndefinedNode(IConstants.AT_ELEMENT, IConstants.AT_NAME, "Unknown");
                break;
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupNode(item=" + what + ")");
            }
        }
        if (modelObject == null) {
            return result;
        }
        return this.adapt(modelObject, INode.class, 0);
    }

    @Override
    public String lookup(INode context, int what, String key, String def) {
        switch (what) {
            case 3: {
                return context.nodeName().getLocalPart();
            }
            case 1: {
                Element elm;
                if (key == null || (elm = this.adapt(context, Element.class, 0)) == null) break;
                String result = elm.lookupPrefix(key);
                return result != null ? result : def;
            }
            case 0: {
                Element elm;
                if (key == null || (elm = this.adapt(context, Element.class, 0)) == null) break;
                String result = elm.lookupNamespaceURI(key);
                return result != null ? result : def;
            }
            case 2: {
                Element elm = this.adapt(context, Element.class, 0);
                if (elm == null) break;
                StringBuilder text = new StringBuilder();
                Node n = elm.getFirstChild();
                while (n != null) {
                    text.append(n.getTextContent());
                    n = n.getNextSibling();
                }
                return text.toString();
            }
            case 5: {
                break;
            }
            case 4: {
                Element elm = this.adapt(context, Element.class, 0);
                if (elm == null) {
                    return def;
                }
                Document document = elm.getOwnerDocument();
                return document.getDocumentURI();
            }
            case 6: {
                Element elm = this.adapt(context, Element.class, 0);
                if (elm == null) {
                    return def;
                }
                return ModelQueryImpl.computeXPathTo(elm);
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupText(item=" + what + ")");
            }
        }
        return def;
    }

    @Override
    public int lookup(INode context, int what, int def) {
        Element elm = this.adapt(context, Element.class, 0);
        if (elm == null) {
            return def;
        }
        String key = null;
        switch (what) {
            case 0: {
                key = "location.line";
                break;
            }
            case 1: {
                key = "location.column";
                break;
            }
            case 2: {
                key = "location.charStart";
                break;
            }
            case 3: {
                key = "location.charEnd";
                break;
            }
            case 4: {
                key = "location2.line";
                break;
            }
            case 5: {
                key = "location2.column";
                break;
            }
            case 6: {
                key = "location2.charStart";
                break;
            }
            case 7: {
                key = "location2.charEnd";
                break;
            }
            default: {
                throw new XNotImplemented("Not implemented: lookupNumber(item=" + what + ")");
            }
        }
        try {
            return ((Number)elm.getUserData(key)).intValue();
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    @Override
    public QName createQName(INode context, String name) {
        int index = name.indexOf(58);
        String prefix = index != -1 ? name.substring(0, index) : "";
        String localPart = name.substring(index + 1);
        String namespaceURI = this.lookup(context, 0, prefix, null);
        return new QName(namespaceURI, localPart, prefix);
    }

    @Override
    public <T> T adapt(Object target, Class<T> type, int hint) {
        INode aTarget;
        Object value;
        if (type.isInstance(target) || target == null) {
            return type.cast(target);
        }
        if (target instanceof Node) {
            Node node = (Node)target;
            if (type == INode.class) {
                Object adapter = node.getUserData(DOMNodeAdapter.KEY);
                if (adapter instanceof DOMNodeAdapter) {
                    return type.cast(adapter);
                }
                adapter = new DOMNodeAdapter(node);
                node.setUserData(DOMNodeAdapter.KEY, adapter, null);
                return type.cast(adapter);
            }
        }
        if (target instanceof INode && type.isInstance(value = (aTarget = (INode)target).nodeValue())) {
            return type.cast(value);
        }
        return null;
    }

    protected static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String computeXPathTo(Node child) {
        Stack<String> stack = new Stack<String>();
        Node parent = null;
        if (child.getNodeType() == 4) {
            return "--No XPath to CDATA NODE exists --";
        }
        if (child.getNodeType() == 2) {
            Attr att = (Attr)child;
            stack.push("/@" + att.getName());
            child = att.getOwnerElement();
        }
        parent = child.getParentNode();
        while (parent != null && parent != child) {
            NodeList nl = parent.getChildNodes();
            int idx = 1;
            int cnt = 0;
            int i = 0;
            int j = nl.getLength();
            while (i < j) {
                Node anode = nl.item(i);
                if (anode.getNodeType() == child.getNodeType() && anode.getNodeName().equals(child.getNodeName())) {
                    ++cnt;
                    if (anode.equals(child)) {
                        idx = cnt;
                    }
                }
                ++i;
            }
            String cmd = "";
            switch (child.getNodeType()) {
                case 3: {
                    cmd = "/text()";
                    break;
                }
                case 8: {
                    cmd = "/comment()";
                    break;
                }
                default: {
                    String ns = child.getNamespaceURI();
                    cmd = ns == null || ns.length() == 0 ? "/" + child.getNodeName() : (child.getPrefix() == null ? "/:" + child.getLocalName() : "/" + child.getPrefix() + ":" + child.getLocalName());
                }
            }
            stack.push(String.valueOf(cmd) + (cnt == 1 ? "" : "[" + idx + "]"));
            parent = parent.getParentNode();
            child = child.getParentNode();
        }
        StringBuilder xpath = new StringBuilder(256);
        while (!stack.isEmpty()) {
            xpath.append((String)stack.pop());
        }
        return xpath.toString();
    }

    @Override
    public int priority() {
        return 0;
    }

    public static final void register(IModelQuery mq) {
        gModelQuery = mq;
        gModelQueryList.add(mq);
        gaModelQuery = null;
    }

    public static final IModelQuery getModelQuery() {
        if (gModelQuery != null) {
            return gModelQuery;
        }
        if ((gaModelQuery = gModelQueryList.toArray(gaModelQuery)).length == 0) {
            gModelQuery = new ModelQueryImpl();
        } else if (gaModelQuery.length == 1) {
            gModelQuery = gaModelQuery[0];
        } else {
            Arrays.sort(gaModelQuery, new Comparator<IModelQuery>(){

                @Override
                public int compare(IModelQuery o1, IModelQuery o2) {
                    return o1.priority() - o2.priority();
                }
            });
            gModelQuery = (IModelQuery)Proxy.newProxyInstance(ModelQueryImpl.class.getClassLoader(), new Class[]{IModelQuery.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = null;
                    IModelQuery[] iModelQueryArray = gaModelQuery;
                    int n = gaModelQuery.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelQuery mq = iModelQueryArray[n2];
                        try {
                            result = method.invoke((Object)mq, args);
                            if (result != null) {
                                return result;
                            }
                        }
                        catch (XNotImplemented xNotImplemented) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    return result;
                }
            });
        }
        return gModelQuery;
    }

    @Override
    public List<Import> findConflictingXSD(Process process, INode node) {
        EObject o1 = this.adapt(node, EObject.class, 0);
        List<Import> imports = null;
        ArrayList<Import> conflicts = new ArrayList<Import>();
        QName qname = null;
        if (o1 instanceof XSDTypeDefinition) {
            qname = this.createQName(node, ((XSDTypeDefinition)o1).getName());
            if ("".equals(qname.getNamespaceURI())) {
                qname = new QName(((XSDTypeDefinition)o1).getTargetNamespace(), qname.getLocalPart());
            }
            imports = EmfModelQuery.scanAllImports(process, qname, XSDUtil.XSD_TYPE_DEFINITION);
        } else if (o1 instanceof XSDElementDeclaration) {
            qname = this.createQName(node, ((XSDElementDeclaration)o1).getName());
            if ("".equals(qname.getNamespaceURI())) {
                qname = new QName(((XSDElementDeclaration)o1).getTargetNamespace(), qname.getLocalPart());
            }
            imports = EmfModelQuery.scanAllImports(process, qname, XSDUtil.XSD_ELEMENT_DECLARATION);
        }
        if (imports != null && imports.size() > 1) {
            EObject o2 = null;
            o1 = null;
            for (Import imp : imports) {
                EObject resolvedImport = EmfModelQuery.lookupImport((EObject)imp, null);
                if (o1 == null) {
                    o1 = o1 instanceof XSDTypeDefinition ? EmfModelQuery.lookupXSDType(resolvedImport, qname) : EmfModelQuery.lookupXSDElement(resolvedImport, qname);
                    conflicts.add(imp);
                    continue;
                }
                if (this.emfModelQuery.compatibleType(o1, o2 = o2 instanceof XSDTypeDefinition ? EmfModelQuery.lookupXSDType(resolvedImport, qname) : EmfModelQuery.lookupXSDElement(resolvedImport, qname))) continue;
                conflicts.add(imp);
            }
        }
        return conflicts.size() > 1 ? conflicts : null;
    }

    @Override
    public Process lookupProcess(INode node) {
        EObject root = EmfModelQuery.getRoot(this.adapt(node, EObject.class, 0));
        if (root instanceof Process) {
            return (Process)root;
        }
        return null;
    }
}

