/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.core.util.Util;

public class AbstractDataLoader {
    protected InputStream stream;
    protected DataInputStream in;
    private List<String> stringIndex = new ArrayList<String>();

    public AbstractDataLoader(InputStream stream) {
        this.stream = stream;
        this.in = new DataInputStream(this.stream);
    }

    protected void readStrings() throws IOException {
        int stringCount = this.in.readInt();
        int i = 0;
        while (i < stringCount) {
            this.stringIndex.add(new String(Util.readUTF(this.in)));
            ++i;
        }
    }

    protected int readNum(int id1, int id2) throws IOException {
        byte b = this.in.readByte();
        if (b == id1) {
            return this.in.readByte();
        }
        if (b == id2) {
            return this.in.readInt();
        }
        return 0;
    }

    protected String readString() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            return null;
        }
        if (b == 1) {
            byte pos = this.in.readByte();
            return this.stringIndex.get(pos);
        }
        if (b == 2) {
            int pos = this.in.readInt();
            return this.stringIndex.get(pos);
        }
        if (b == 3) {
            int basePos = this.readNum(1, 2);
            int pos = this.readNum(1, 2);
            int len = this.readNum(1, 2);
            String base = this.stringIndex.get(basePos);
            String str = base.substring(pos, pos + len);
            return str;
        }
        if (b == 4) {
            int count = this.in.readInt();
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < count) {
                buffer.append(this.readString());
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }
}

