/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class ModelModuleType
implements IEvaluatedType {
    private IModule fModule = null;
    private int fStepCount = 1;

    public ModelModuleType(IModule module) {
        this.fModule = module;
    }

    public ModelModuleType(IModule module, int stepCount) {
        this.fModule = module;
        this.fStepCount = stepCount;
    }

    @Override
    public String getTypeName() {
        if (this.fModule != null) {
            return "model module:" + this.fModule.getElementName();
        }
        return "model module: unknown";
    }

    public IModule getModule() {
        return this.fModule;
    }

    public int getStepCount() {
        return this.fStepCount;
    }

    @Override
    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fModule == null ? 0 : this.fModule.hashCode());
        result = 31 * result + this.fStepCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelModuleType other = (ModelModuleType)obj;
        if (this.fModule == null ? other.fModule != null : !this.fModule.equals(other.fModule)) {
            return false;
        }
        return this.fStepCount == other.fStepCount;
    }
}

