/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ModelElement;

public class ModelElementInfo {
    private List<IModelElement> children;
    public static final Object[] NO_NON_SCRIPT_RESOURCES = new Object[0];

    protected ModelElementInfo() {
    }

    public void addChild(IModelElement child) {
        if (this.children == null) {
            this.children = new ArrayList<IModelElement>(5);
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public int size() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    protected IModelElement get(int i) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(i);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    public IModelElement[] getChildren() {
        if (this.children == null) {
            return ModelElement.NO_ELEMENTS;
        }
        return this.children.toArray(new IModelElement[this.children.size()]);
    }

    public List<IModelElement> getChildrenAsList() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void removeChild(IModelElement child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void setChildren(IModelElement[] children) {
        if (children == null) {
            this.children = null;
        } else {
            this.children = new ArrayList<IModelElement>(children.length);
            int i = 0;
            while (i < children.length) {
                this.children.add(children[i]);
                ++i;
            }
        }
    }

    public void setChildren(List<IModelElement> children) {
        this.children = children == null ? null : new ArrayList<IModelElement>(children);
    }
}

