/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class CommitEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.egit.ui.internal.commit.CommitEditorInputFactory";
    public static final String COMMIT = "commit";
    public static final String PATH = "path";
    public static final String STASH = "stash";

    public static void saveState(IMemento memento, CommitEditorInput input) {
        RepositoryCommit commit = input.getCommit();
        memento.putString(COMMIT, commit.getRevCommit().name());
        memento.putString(PATH, commit.getRepository().getDirectory().getAbsolutePath());
        memento.putBoolean(STASH, commit.isStash());
    }

    protected Repository getRepository(IMemento memento) {
        String path = memento.getString(PATH);
        if (path == null) {
            return null;
        }
        File gitDir = new File(path);
        if (!gitDir.exists()) {
            return null;
        }
        try {
            return Activator.getDefault().getRepositoryCache().lookupRepository(gitDir);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected RepositoryCommit getCommit(IMemento memento, Repository repository) {
        String id = memento.getString(COMMIT);
        if (id == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)id));
                RevCommit[] revCommitArray = commit.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit parent = revCommitArray[n2];
                    walk.parseBody((RevObject)parent);
                    ++n2;
                }
                RepositoryCommit repositoryCommit = new RepositoryCommit(repository, commit);
                Boolean isStash = memento.getBoolean(STASH);
                if (isStash != null) {
                    repositoryCommit.setStash(isStash);
                }
                return repositoryCommit;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public IAdaptable createElement(IMemento memento) {
        Repository repository = this.getRepository(memento);
        if (repository == null) {
            return null;
        }
        RepositoryCommit commit = this.getCommit(memento, repository);
        if (commit == null) {
            return null;
        }
        return new CommitEditorInput(commit);
    }
}

