/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.InterceptorsType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.Relationships;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.mergers.AssemblyDescriptorMerger;
import org.eclipse.jst.jee.model.internal.mergers.IMerger;
import org.eclipse.jst.jee.model.internal.mergers.MessageDrivenBeanMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;
import org.eclipse.jst.jee.model.internal.mergers.SessionBeanMerger;

public class EjbJarMerger
extends ModelElementMerger {
    public EjbJarMerger(JavaEEObject _base, JavaEEObject merge, int kind) {
        super(_base, merge, kind);
    }

    EJBJar getBaseEjbJar() {
        return (EJBJar)this.getBase();
    }

    EJBJar getToMergeEjbJar() {
        return (EJBJar)this.getToMerge();
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        try {
            this.copyGeneralData(warnings);
            this.mergeSessionBeans(warnings);
            this.mergeMdbs(warnings);
            this.mergeEntities(warnings);
            this.mergeAssemblyDescriptor(warnings);
        }
        catch (Exception e) {
            throw new ModelException(e);
        }
        return warnings;
    }

    private void mergeAssemblyDescriptor(List warnings) throws ModelException {
        if (this.getToMergeEjbJar().getAssemblyDescriptor() == null) {
            return;
        }
        if (this.getBaseEjbJar().getAssemblyDescriptor() == null) {
            this.getBaseEjbJar().setAssemblyDescriptor(EjbFactory.eINSTANCE.createAssemblyDescriptor());
        }
        AssemblyDescriptorMerger adMerger = new AssemblyDescriptorMerger((JavaEEObject)this.getBaseEjbJar().getAssemblyDescriptor(), (JavaEEObject)this.getToMergeEjbJar().getAssemblyDescriptor(), ModelElementMerger.ADD);
        warnings.addAll(adMerger.process());
    }

    private void mergeEntities(List warnings) {
        if (!this.isEnterpriseBeansTagPresent()) {
            return;
        }
        List entityBeansToMerge = this.getToMergeEjbJar().getEnterpriseBeans().getEntityBeans();
        List entityBeansBase = this.getBaseEjbJar().getEnterpriseBeans().getEntityBeans();
        if (!entityBeansToMerge.isEmpty()) {
            for (Object entity : entityBeansToMerge) {
                EntityBean entityType = (EntityBean)entity;
                EntityBean entityBean = this.getEntityBean(entityType.getEjbName(), entityBeansBase);
                if (entityBean != null || !this.isValidArtifact(entity)) continue;
                entityBeansBase.add(EcoreUtil.copy((EObject)((EObject)entity)));
            }
        }
    }

    private boolean isEnterpriseBeansTagPresent() {
        if (this.getToMergeEjbJar().getEnterpriseBeans() == null) {
            return false;
        }
        if (this.getBaseEjbJar().getEnterpriseBeans() == null) {
            this.getBaseEjbJar().setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        }
        return this.getToMergeEjbJar().getEnterpriseBeans().getEntityBeans() != null && !this.getToMergeEjbJar().getEnterpriseBeans().getEntityBeans().isEmpty() || this.getToMergeEjbJar().getEnterpriseBeans().getSessionBeans() != null && !this.getToMergeEjbJar().getEnterpriseBeans().getSessionBeans().isEmpty() || this.getToMergeEjbJar().getEnterpriseBeans().getMessageDrivenBeans() != null && !this.getToMergeEjbJar().getEnterpriseBeans().getMessageDrivenBeans().isEmpty();
    }

    private void mergeSessionBeans(List warnings) throws Exception {
        if (!this.isEnterpriseBeansTagPresent()) {
            return;
        }
        List sessionBeansToMerge = this.getToMergeEjbJar().getEnterpriseBeans().getSessionBeans();
        List sessionBeansBase = this.getBaseEjbJar().getEnterpriseBeans().getSessionBeans();
        for (Object session : sessionBeansToMerge) {
            SessionBean sessionType = (SessionBean)session;
            SessionBean baseBean = this.getSessionBean(sessionType.getEjbName(), sessionBeansBase);
            if (baseBean != null) {
                IMerger m = this.getSessionMerger(baseBean, sessionType, this.getKind());
                if (m == null) continue;
                warnings.addAll(m.process());
                continue;
            }
            if (!this.isValidArtifact(session)) continue;
            sessionBeansBase.add(EcoreUtil.copy((EObject)((EObject)session)));
        }
    }

    private IMerger getSessionMerger(SessionBean baseBean, SessionBean toMergeType, int kind) {
        return new SessionBeanMerger(baseBean, toMergeType, kind);
    }

    private void mergeMdbs(List warnings) throws Exception {
        if (!this.isEnterpriseBeansTagPresent()) {
            return;
        }
        List mdBeansToMerge = this.getToMergeEjbJar().getEnterpriseBeans().getMessageDrivenBeans();
        List mdBeansBase = this.getBaseEjbJar().getEnterpriseBeans().getMessageDrivenBeans();
        for (Object mdb : mdBeansToMerge) {
            MessageDrivenBean sessionType = (MessageDrivenBean)mdb;
            MessageDrivenBean baseBean = this.getMdbBean(sessionType.getEjbName(), mdBeansBase);
            if (baseBean != null) {
                IMerger m = this.getMdbMerger(baseBean, sessionType, this.getKind());
                if (m == null) continue;
                warnings.addAll(m.process());
                continue;
            }
            if (!this.isValidArtifact(mdb)) continue;
            mdBeansBase.add(EcoreUtil.copy((EObject)((EObject)mdb)));
        }
    }

    private IMerger getMdbMerger(MessageDrivenBean baseBean, MessageDrivenBean toMergeType, int kind) {
        return new MessageDrivenBeanMerger(baseBean, toMergeType, kind);
    }

    private MessageDrivenBean getMdbBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            MessageDrivenBean sBean = (MessageDrivenBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    private SessionBean getSessionBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            SessionBean sBean = (SessionBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    private EntityBean getEntityBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            EntityBean sBean = (EntityBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    private void copyGeneralData(List warnings) {
        this.copyJavaEEGroup();
        if (this.getToMergeEjbJar().getRelationships() != null && this.getToMergeEjbJar().getRelationships().getEjbRelations() != null && this.getToMergeEjbJar().getRelationships().getEjbRelations().size() > 0) {
            this.getBaseEjbJar().setRelationships((Relationships)EcoreUtil.copy((EObject)((EObject)this.getToMergeEjbJar().getRelationships())));
        }
        if (this.getToMergeEjbJar().getEjbClientJar() != null) {
            this.getBaseEjbJar().setEjbClientJar(this.getToMergeEjbJar().getEjbClientJar());
        }
        if (this.getToMergeEjbJar().getInterceptors() != null && this.getToMergeEjbJar().getInterceptors().getInterceptors() != null && this.getToMergeEjbJar().getInterceptors().getInterceptors().size() > 0) {
            this.getBaseEjbJar().setInterceptors((InterceptorsType)EcoreUtil.copy((EObject)((EObject)this.getToMergeEjbJar().getInterceptors())));
        }
        if (this.getToMergeEjbJar().isSetVersion()) {
            this.getBaseEjbJar().setVersion(this.getToMergeEjbJar().getVersion());
        }
    }

    private void copyAllContentInBase(List listSource, List target) {
        for (Object object : listSource) {
            target.add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }

    private boolean isValidArtifact(Object javaEEObject) {
        if (javaEEObject instanceof SessionBean) {
            return ((SessionBean)javaEEObject).getEjbName() != null;
        }
        if (javaEEObject instanceof EntityBean) {
            return ((EntityBean)javaEEObject).getEjbName() != null;
        }
        if (javaEEObject instanceof MessageDrivenBean) {
            return ((MessageDrivenBean)javaEEObject).getEjbName() != null;
        }
        return true;
    }

    private void copyJavaEEGroup() {
        if (this.getToMergeEjbJar().getDescriptions() != null) {
            this.copyAllContentInBase(this.getToMergeEjbJar().getDescriptions(), this.getBaseEjbJar().getDescriptions());
        }
        if (this.getToMergeEjbJar().getDisplayNames() != null) {
            this.copyAllContentInBase(this.getToMergeEjbJar().getDisplayNames(), this.getBaseEjbJar().getDisplayNames());
        }
        if (this.getToMergeEjbJar().getIcons() != null) {
            this.copyAllContentInBase(this.getToMergeEjbJar().getIcons(), this.getBaseEjbJar().getIcons());
        }
    }
}

