/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.IClassTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.TypeInfo;

public abstract class ClassTypeInfo
extends TypeInfo
implements IClassTypeInfo {
    private static final long serialVersionUID = -5046230589012357680L;
    protected final String _className;
    protected final String[] _superClasses;
    protected final String[] _interfaces;
    private Set _superTypes;

    protected ClassTypeInfo(String className, String[] superClasses, String[] interfaces) {
        this._className = className;
        this._superClasses = superClasses != null ? superClasses : new String[]{};
        String[] stringArray = this._interfaces = interfaces != null ? interfaces : new String[]{};
        if (this._superClasses.length + this._interfaces.length == 0) {
            this._superTypes = Collections.EMPTY_SET;
        }
    }

    public final String[] getInterfaces() {
        if (this._interfaces.length > 0) {
            String[] copy = new String[this._interfaces.length];
            System.arraycopy(this._interfaces, 0, copy, 0, this._interfaces.length);
            return copy;
        }
        return new String[0];
    }

    public final String[] getSuperClasses() {
        if (this._superClasses.length > 0) {
            String[] copy = new String[this._superClasses.length];
            System.arraycopy(this._superClasses, 0, copy, 0, this._superClasses.length);
            return copy;
        }
        return new String[0];
    }

    public final boolean isInstanceOf(String checkType) {
        if (this._superTypes == null) {
            this._superTypes = new HashSet();
            this._superTypes.addAll(Arrays.asList(this._superClasses));
            this._superTypes.addAll(Arrays.asList(this._interfaces));
        }
        return this._superTypes.contains(checkType);
    }

    public final String getClassName() {
        return this._className;
    }

    public String toString() {
        String supers = "[";
        int i = 0;
        while (i < this._superClasses.length) {
            supers = String.valueOf(supers) + this._superClasses[i];
            if (i < this._superClasses.length) {
                supers = String.valueOf(supers) + ",";
            }
            ++i;
        }
        i = 0;
        while (i < this._interfaces.length) {
            supers = String.valueOf(supers) + this._interfaces[i];
            if (i < this._interfaces.length - 1) {
                supers = String.valueOf(supers) + ",";
            }
            ++i;
        }
        supers = String.valueOf(supers) + "]";
        return "class= " + this.getClassName() + ", supers=" + supers;
    }
}

