/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.libra.warproducts.core.WARProductModel;
import org.eclipse.libra.warproducts.core.WARWorkspaceProductModel;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class WARProductInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "warproduct-context";

    public WARProductInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        WARWorkspaceProductModel model = null;
        if (input instanceof IStorageEditorInput) {
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    model = new WARWorkspaceProductModel(file, true);
                    model.load();
                } else if (input instanceof IStorageEditorInput) {
                    IStorageEditorInput storageInput = (IStorageEditorInput)input;
                    InputStream contents = storageInput.getStorage().getContents();
                    BufferedInputStream is = new BufferedInputStream(contents);
                    model = new WARProductModel();
                    model.load((InputStream)is, false);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException((Throwable)e);
                model = null;
            }
        } else if (input instanceof IURIEditorInput) {
            IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            InputStream is = store.openInputStream(4096, (IProgressMonitor)new NullProgressMonitor());
            model = new WARProductModel();
            model.load(is, false);
        }
        return model;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void flushModel(IDocument doc) {
        IEditable editableModel;
        if (this.getModel() instanceof IEditable && (editableModel = (IEditable)this.getModel()).isDirty()) {
            try {
                StringWriter swriter = new StringWriter();
                PrintWriter writer = new PrintWriter(swriter);
                editableModel.save(writer);
                writer.flush();
                swriter.close();
                doc.set(swriter.toString());
            }
            catch (IOException e) {
                PDEPlugin.logException((Throwable)e);
            }
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        IProductModel model = (IProductModel)this.getModel();
        try {
            InputStream is = ((IFile)model.getUnderlyingResource()).getContents();
            model.reload(is, true);
            this.getEditor().doRevert();
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
    }

    protected String getPartitionName() {
        return "___prod_partition";
    }
}

