/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.ResourceDeltaScanner;
import org.sonatype.plexus.build.incremental.EmptyScanner;

public class EclipseIncrementalBuildContext
extends AbstractEclipseBuildContext {
    private final IResourceDelta delta;

    public EclipseIncrementalBuildContext(IResourceDelta delta, Map<String, Object> context, IIncrementalBuildFramework.BuildResultCollector results) {
        super(context, results);
        this.delta = delta;
    }

    public boolean hasDelta(String relPath) {
        Path path = new Path(relPath);
        return this.hasDelta((IPath)path);
    }

    protected boolean hasDelta(IPath path) {
        return this.delta == null || path == null || this.delta.findMember(path) != null;
    }

    public boolean hasDelta(List relPaths) {
        for (String relPath : relPaths) {
            if (!this.hasDelta(relPath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDelta(File file) {
        return this.hasDelta(this.getRelativePath(file));
    }

    public Scanner newDeleteScanner(File basedir) {
        IResourceDelta reldelta = this.getDelta(basedir);
        if (reldelta == null || !EclipseIncrementalBuildContext.isRemove(reldelta)) {
            return new EmptyScanner(basedir);
        }
        return new ResourceDeltaScanner(reldelta, true);
    }

    public Scanner newScanner(File basedir) {
        return this.newScanner(basedir, false);
    }

    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        if (!ignoreDelta) {
            IResourceDelta reldelta = this.getDelta(basedir);
            if (reldelta == null || !EclipseIncrementalBuildContext.isContentChange(reldelta)) {
                return new EmptyScanner(basedir);
            }
            return new ResourceDeltaScanner(reldelta, false);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        return ds;
    }

    private IResourceDelta getDelta(File file) {
        IPath relpath = this.getRelativePath(file);
        if (relpath == null) {
            return null;
        }
        return this.delta.findMember(relpath);
    }

    static boolean isContentChange(IResourceDelta delta) {
        int kind = delta.getKind();
        if (1 == kind) {
            return true;
        }
        if (4 == kind) {
            if (delta.getResource() instanceof IContainer) {
                return true;
            }
            int flags = delta.getFlags();
            return (flags & 0x100) != 0;
        }
        return false;
    }

    static boolean isRemove(IResourceDelta delta) {
        int kind = delta.getKind();
        if (2 == kind) {
            return true;
        }
        return 4 == kind && delta.getResource() instanceof IContainer;
    }

    @Override
    protected IResource getBaseResource() {
        return this.delta.getResource();
    }

    public boolean isIncremental() {
        return true;
    }
}

