/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.core.auth;

import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;

public class OpenIdCredentials
extends AuthenticationCredentials {
    private final String responseUrl;
    private final String token;

    public OpenIdCredentials(String responseUrl, String token) {
        this.responseUrl = responseUrl;
        this.token = token;
    }

    protected OpenIdCredentials(ICredentialsStore store, String prefix, boolean loadSecrets) {
        this(store.get(String.valueOf(prefix) + ".responseUrl", null), store.get(String.valueOf(prefix) + ".token", null));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenIdCredentials other = (OpenIdCredentials)obj;
        if (this.responseUrl == null ? other.responseUrl != null : !this.responseUrl.equals(other.responseUrl)) {
            return false;
        }
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    public String getToken() {
        return this.token;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.responseUrl == null ? 0 : this.responseUrl.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    @Override
    public void clear(ICredentialsStore store, String prefix) {
        store.remove(String.valueOf(prefix) + ".responseUrl");
        store.remove(String.valueOf(prefix) + ".token");
    }

    @Override
    public void save(ICredentialsStore store, String prefix) {
        store.put(String.valueOf(prefix) + ".responseUrl", this.responseUrl, true);
        store.put(String.valueOf(prefix) + ".token", this.token, true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OpenIdCredentials [responseUrl=");
        builder.append(this.responseUrl);
        builder.append(", token=");
        builder.append(this.token);
        builder.append("]");
        return builder.toString();
    }
}

