/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.mylyn.wikitext.parser.css.CssParser;
import org.eclipse.mylyn.wikitext.parser.css.Stylesheet;

public class Preferences
implements Cloneable {
    private static final String KEY_MARKUP_VIEWER_CSS = "preview.css";
    private static final String KEY_EDITOR_FOLDING = "editorFolding";
    private static final Pattern BAD_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    public static final String PHRASE_CODE = "@code@";
    public static final String PHRASE_SPAN = "%span%";
    public static final String PHRASE_SUBSCRIPT = "~subscript~";
    public static final String PHRASE_SUPERSCRIPT = "^superscript^";
    public static final String PHRASE_INSERTED_TEXT = "+inserted text+";
    public static final String PHRASE_DELETED_TEXT = "-deleted text-";
    public static final String PHRASE_CITATION = "??citation??";
    public static final String PHRASE_BOLD = "**bold**";
    public static final String PHRASE_ITALIC = "__italic__";
    public static final String PHRASE_STRONG = "*strong*";
    public static final String PHRASE_EMPHASIS = "_emphasis_";
    public static final String PHRASE_MONOSPACE = "monospace";
    public static final String PHRASE_UNDERLINED = "underlined";
    public static final String PHRASE_QUOTE = "quote";
    public static final String PHRASE_MARK = "mark";
    public static final String BLOCK_QUOTE = "bq.";
    public static final String BLOCK_PRE = "pre.";
    public static final String BLOCK_BC = "bc.";
    public static final String BLOCK_H6 = "h6.";
    public static final String BLOCK_H5 = "h5.";
    public static final String BLOCK_H4 = "h4.";
    public static final String BLOCK_H3 = "h3.";
    public static final String BLOCK_H2 = "h2.";
    public static final String BLOCK_H1 = "h1.";
    public static final String BLOCK_DT = "dt";
    public static final String KEY_OPEN_AS_PREVIEW_NAME_PATTERN = "openAsPreviewNamePattern";
    public static final String[] HEADING_PREFERENCES;
    private Map<String, String> cssByBlockModifierType = new LinkedHashMap<String, String>();
    private Map<String, String> cssByPhraseModifierType;
    private boolean editorFolding;
    private String openAsPreviewFileNamePattern;
    private String markupViewerCss;
    private Stylesheet stylesheet;
    private boolean mutable;

    static {
        String[] stringArray = new String[7];
        stringArray[1] = BLOCK_H1;
        stringArray[2] = BLOCK_H2;
        stringArray[3] = BLOCK_H3;
        stringArray[4] = BLOCK_H4;
        stringArray[5] = BLOCK_H5;
        stringArray[6] = BLOCK_H6;
        HEADING_PREFERENCES = stringArray;
    }

    public Preferences() {
        this.cssByBlockModifierType.put(BLOCK_H1, "font-size: 120%; font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_H2, "font-size: 110%; font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_H3, "font-size: 105%; font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_H4, "font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_H5, "font-size: 90%; font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_H6, "font-size: 80%; font-weight: bold; color: #172f47;");
        this.cssByBlockModifierType.put(BLOCK_BC, "font-family: monospace; color: #4444CC;");
        this.cssByBlockModifierType.put(BLOCK_PRE, "font-family: monospace;");
        this.cssByBlockModifierType.put(BLOCK_QUOTE, "color: rgb(38,86,145);");
        this.cssByBlockModifierType.put(BLOCK_DT, "font-weight: bold;");
        this.cssByPhraseModifierType = new LinkedHashMap<String, String>();
        this.cssByPhraseModifierType.put(PHRASE_EMPHASIS, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_STRONG, "font-weight: bold;");
        this.cssByPhraseModifierType.put(PHRASE_ITALIC, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_BOLD, "font-weight: bold;");
        this.cssByPhraseModifierType.put(PHRASE_CITATION, "font-style: italic;");
        this.cssByPhraseModifierType.put(PHRASE_DELETED_TEXT, "text-decoration: line-through;");
        this.cssByPhraseModifierType.put(PHRASE_INSERTED_TEXT, "text-decoration: underline;");
        this.cssByPhraseModifierType.put(PHRASE_SUPERSCRIPT, "font-size: smaller; vertical-align: super;");
        this.cssByPhraseModifierType.put(PHRASE_SUBSCRIPT, "font-size: smaller; vertical-align: sub;");
        this.cssByPhraseModifierType.put(PHRASE_SPAN, "");
        this.cssByPhraseModifierType.put(PHRASE_CODE, "font-family: monospace; color: #4444CC;");
        this.cssByPhraseModifierType.put(PHRASE_MONOSPACE, "font-family: monospace;");
        this.cssByPhraseModifierType.put(PHRASE_UNDERLINED, "text-decoration: underline;");
        this.cssByPhraseModifierType.put(PHRASE_QUOTE, "color: rgb(38,86,145);");
        this.cssByPhraseModifierType.put(PHRASE_MARK, "background-color: yellow;");
        this.editorFolding = true;
        this.openAsPreviewFileNamePattern = "(?i)readme\\.\\w+";
        this.mutable = true;
    }

    public Map<String, String> getCssByBlockModifierType() {
        return this.cssByBlockModifierType;
    }

    public Map<String, String> getCssByPhraseModifierType() {
        return this.cssByPhraseModifierType;
    }

    public boolean isEditorFolding() {
        return this.editorFolding;
    }

    public void setEditorFolding(boolean editorFolding) {
        if (!this.mutable) {
            throw new UnsupportedOperationException();
        }
        this.editorFolding = editorFolding;
    }

    public String getMarkupViewerCss() {
        if (this.markupViewerCss == null) {
            this.markupViewerCss = this.getDefaultMarkupViewerCss();
        }
        return this.markupViewerCss;
    }

    public void setMarkupViewerCss(String markupViewerCss) {
        if (!this.mutable) {
            throw new UnsupportedOperationException();
        }
        this.markupViewerCss = markupViewerCss;
        this.stylesheet = null;
    }

    public Stylesheet getStylesheet() {
        if (this.stylesheet == null) {
            this.stylesheet = new CssParser().parse(this.getMarkupViewerCss());
        }
        return this.stylesheet;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        if (this.mutable) {
            this.mutable = false;
            this.cssByBlockModifierType = Collections.unmodifiableMap(this.cssByBlockModifierType);
            this.cssByPhraseModifierType = Collections.unmodifiableMap(this.cssByPhraseModifierType);
        }
    }

    public void save(IPreferenceStore store, boolean asDefault) {
        String propKey;
        for (Map.Entry<String, String> ent : this.cssByBlockModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), true);
            if (asDefault) {
                store.setDefault(propKey, ent.getValue());
                continue;
            }
            store.setValue(propKey, ent.getValue());
        }
        for (Map.Entry<String, String> ent : this.cssByPhraseModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), false);
            if (asDefault) {
                store.setDefault(propKey, ent.getValue());
                continue;
            }
            store.setValue(propKey, ent.getValue());
        }
        if (asDefault) {
            store.setDefault(KEY_EDITOR_FOLDING, this.editorFolding);
            store.setDefault(KEY_MARKUP_VIEWER_CSS, this.getDefaultMarkupViewerCss());
            store.setDefault(KEY_OPEN_AS_PREVIEW_NAME_PATTERN, this.openAsPreviewFileNamePattern);
        } else {
            store.setValue(KEY_EDITOR_FOLDING, this.editorFolding);
            store.setValue(KEY_MARKUP_VIEWER_CSS, this.markupViewerCss);
            store.setValue(KEY_OPEN_AS_PREVIEW_NAME_PATTERN, this.openAsPreviewFileNamePattern);
        }
    }

    public static String toPreferenceKey(String key, boolean block) {
        String propKey = String.valueOf(block ? "block-" : "phrase-") + BAD_CHAR_PATTERN.matcher(key).replaceAll("");
        return propKey;
    }

    public void load(IPreferenceStore store) {
        String value;
        String propKey;
        if (!this.mutable) {
            throw new UnsupportedOperationException();
        }
        for (Map.Entry<String, String> ent : this.cssByBlockModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), true);
            value = store.getString(propKey);
            if (value == null) continue;
            ent.setValue(value);
        }
        for (Map.Entry<String, String> ent : this.cssByPhraseModifierType.entrySet()) {
            propKey = Preferences.toPreferenceKey(ent.getKey(), false);
            value = store.getString(propKey);
            if (value == null) continue;
            ent.setValue(value);
        }
        this.editorFolding = store.getBoolean(KEY_EDITOR_FOLDING);
        this.markupViewerCss = store.getString(KEY_MARKUP_VIEWER_CSS);
        this.openAsPreviewFileNamePattern = store.getString(KEY_OPEN_AS_PREVIEW_NAME_PATTERN);
        if (this.isEmpty(this.markupViewerCss)) {
            this.markupViewerCss = this.getDefaultMarkupViewerCss();
        }
        this.stylesheet = null;
    }

    private String getDefaultMarkupViewerCss() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Reader reader = HtmlTextPresentationParser.getDefaultStylesheetContent();){
                return CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            WikiTextUiPlugin.getDefault().log(e);
            return "";
        }
    }

    private boolean isEmpty(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        int length = text.length();
        int x = 0;
        while (x < length) {
            char c = text.charAt(x);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public String getPreviewFileNamePattern() {
        return this.openAsPreviewFileNamePattern;
    }

    public void setPreviewFileNamePattern(String previewFileNamePattern) {
        this.openAsPreviewFileNamePattern = previewFileNamePattern;
    }

    public Preferences clone() {
        try {
            Preferences copy = (Preferences)super.clone();
            copy.mutable = true;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

