/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class StructuredContentProvider<INPUT>
extends ViewerSorter
implements IStructuredContentProvider,
IListener {
    private StructuredViewer viewer;
    private INPUT input;
    private Font italicFont;
    private Font boldFont;

    public void dispose() {
        if (this.input != null) {
            this.disconnectInput(this.input);
            this.input = null;
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
            this.italicFont = null;
        }
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
    }

    public INPUT getInput() {
        return this.input;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
        if (newInput != this.input) {
            if (this.input != null) {
                this.disconnectInput(this.input);
            }
            try {
                this.input = newInput;
                if (this.input != null) {
                    this.connectInput(this.input);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                this.input = null;
            }
        }
    }

    protected void connectInput(INPUT input) {
    }

    protected void disconnectInput(INPUT input) {
    }

    public void notifyEvent(IEvent event) {
        this.refreshViewer(true);
    }

    public void refreshViewer(boolean updateLabels) {
        UIUtil.refreshElement(this.viewer, null, updateLabels);
    }

    public void refreshElement(Object element, boolean updateLabels) {
        UIUtil.refreshElement(this.viewer, element, updateLabels);
    }

    @Deprecated
    public void refreshSynced(Object element, boolean updateLabels) {
        this.refreshElement(element, updateLabels);
    }

    public void updateLabels(Object element) {
        UIUtil.updateElements(this.viewer, element);
    }

    public void revealElement(final Object element) {
        try {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        StructuredContentProvider.this.viewer.reveal(element);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void selectElement(final Object element, final boolean reveal) {
        try {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        StructuredContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection(element), reveal);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void expandElement(final Object element, final int level) {
        if (element != null && this.getViewer() instanceof TreeViewer) {
            final TreeViewer viewer = (TreeViewer)this.getViewer();
            try {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            viewer.expandToLevel(element, level);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected Display getDisplay() {
        Display display = this.viewer.getControl().getDisplay();
        if (display == null) {
            display = UIUtil.getDisplay();
        }
        return display;
    }

    protected synchronized Font getItalicFont() {
        if (this.italicFont == null && this.viewer != null) {
            this.italicFont = UIUtil.getItalicFont(this.viewer.getControl());
        }
        return this.italicFont;
    }

    protected synchronized Font getBoldFont() {
        if (this.boldFont == null && this.viewer != null) {
            this.boldFont = UIUtil.getBoldFont(this.viewer.getControl());
        }
        return this.boldFont;
    }
}

