/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.prefs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.om.pref.OMPreferences;
import org.eclipse.net4j.util.ui.prefs.OMPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class OMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private OMPreferenceStore preferenceStore;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            OMPreferencePage.this.dialogChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            OMPreferencePage.this.dialogChanged();
        }
    };
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            OMPreferencePage.this.dialogChanged();
        }
    };

    public OMPreferencePage(OMPreferences preferences) {
        this.preferenceStore = new OMPreferenceStore(preferences);
    }

    public OMPreferences getPreferences() {
        return this.preferenceStore.getPreferences();
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.preferenceStore;
    }

    protected final SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected final ModifyListener getModifyListener() {
        return this.modifyListener;
    }

    protected void dialogChanged() {
    }

    protected final Control createContents(Composite parent) {
        try {
            Control control = this.createUI(parent);
            this.dialogChanged();
            this.addListeners(control);
            return control;
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }

    protected void addListeners(Control control) {
        Text c;
        if (control instanceof Text) {
            c = (Text)control;
            c.addModifyListener(this.modifyListener);
        }
        if (control instanceof Combo) {
            c = (Combo)control;
            c.addModifyListener(this.modifyListener);
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof CCombo) {
            c = (CCombo)control;
            c.addModifyListener(this.modifyListener);
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof List) {
            c = (List)control;
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof DateTime) {
            c = (DateTime)control;
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Table) {
            c = (Table)control;
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Tree) {
            c = (Table)control;
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Button) {
            c = (Button)control;
            c.addSelectionListener(this.selectionListener);
        }
        if (control instanceof Composite) {
            c = (Composite)control;
            Control[] controlArray = c.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addListeners(child);
                ++n2;
            }
        }
    }

    protected abstract Control createUI(Composite var1);
}

