/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElement;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.databinding.ExtendedMultiplicityObservableValue;
import org.eclipse.papyrus.uml.properties.databinding.ExtensionEndMultiplicityObservableValue;
import org.eclipse.papyrus.uml.properties.databinding.NavigationObservableValue;
import org.eclipse.papyrus.uml.properties.databinding.OwnerObservableValue;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class MemberEndModelElement
extends AbstractModelElement {
    protected EObject source;
    protected EditingDomain domain;
    public static final String MULTIPLICITY = "multiplicity";
    public static final String OWNER = "owner";
    public static final String NAVIGABLE = "navigable";

    public MemberEndModelElement(EObject source, EditingDomain domain) {
        this.source = source;
        this.domain = domain;
    }

    public IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals(MULTIPLICITY)) {
            if (this.source instanceof ExtensionEnd) {
                return new ExtensionEndMultiplicityObservableValue((ExtensionEnd)this.source, this.domain);
            }
            return new ExtendedMultiplicityObservableValue(this.source, this.domain);
        }
        if (propertyPath.equals(OWNER)) {
            return new OwnerObservableValue(this.source, this.domain);
        }
        if (propertyPath.equals(NAVIGABLE)) {
            return new NavigationObservableValue(this.source, this.domain);
        }
        Activator.log.warn("The property " + propertyPath + " doesn't exist");
        return null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(MULTIPLICITY)) {
            if (this.source instanceof ExtensionEnd) {
                return new StaticContentProvider((Object[])new String[]{"1", "0..1"});
            }
            return new StaticContentProvider((Object[])new String[]{"0..*", "1..*", "0..1", "1"});
        }
        if (propertyPath.equals(OWNER)) {
            return new StaticContentProvider((Object[])new String[]{"Association", "Classifier"});
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        return true;
    }

    public boolean isEditable(String propertyPath) {
        if (propertyPath.equals(OWNER)) {
            EList memberEnds = ((Property)this.source).getAssociation().getMemberEnds();
            if (memberEnds.size() == 2 && this.isAssociation((Property)memberEnds.get(0)) && this.isAssociation((Property)memberEnds.get(1))) {
                return false;
            }
            return ((Property)this.source).getAssociation().getMemberEnds().size() <= 2 && !EMFHelper.isReadOnly((EObject)this.source);
        }
        return !EMFHelper.isReadOnly((EObject)this.source);
    }

    private boolean isAssociation(Property property) {
        if (property.getType() == null) {
            return false;
        }
        return property.getType().eClass() == UMLPackage.eINSTANCE.getAssociation();
    }

    public boolean forceRefresh(String propertyPath) {
        return propertyPath.equals(NAVIGABLE) || propertyPath.equals(OWNER);
    }
}

