/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.papyrus.uml.properties.widgets.RichTextEditorCompositeWrapper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RichTextObservableValue
extends AbstractObservableValue
implements Listener,
FocusListener,
ModifyListener,
KeyListener {
    private RichTextEditorCompositeWrapper richTextEditor;
    private int eventType;
    private Object currentValue;
    protected AggregatedObservable modelProperty;

    public RichTextObservableValue(RichTextEditorCompositeWrapper richTextEditor, IObservableValue modelProperty, int eventType) {
        this.richTextEditor = richTextEditor;
        this.eventType = eventType;
        if (modelProperty instanceof AggregatedObservable) {
            this.modelProperty = (AggregatedObservable)modelProperty;
        }
        this.richTextEditor.addListener(eventType, this);
        this.richTextEditor.addFocusListener(this);
        this.richTextEditor.addModifyListener(this);
        this.richTextEditor.addKeyListener(this);
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue() {
        if (UnchangedObject.instance.toString().equals(this.richTextEditor.getText())) {
            return null;
        }
        return this.richTextEditor.getText();
    }

    protected void doSetValue(Object value) {
        if (this.modelProperty != null && this.modelProperty.hasDifferentValues()) {
            this.richTextEditor.setText(UnchangedObject.instance.toString());
            this.currentValue = UnchangedObject.instance;
        } else if (value instanceof String) {
            this.richTextEditor.setText((String)value);
            this.currentValue = value;
        } else if (value == null) {
            this.richTextEditor.setText("");
            this.currentValue = null;
        }
    }

    public void handleEvent(Event event) {
        this.valueChanged(event);
    }

    public synchronized void dispose() {
        this.richTextEditor.removeListener(this.eventType, this);
        this.richTextEditor.removeFocusListener(this);
        this.richTextEditor.removeModifyListener(this);
        this.richTextEditor.removeKeyListener(this);
        super.dispose();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.valueChanged(null);
    }

    public void modifyText(ModifyEvent e) {
        this.valueChanged(null);
    }

    public void updateReferences() {
        this.doSetValue(this.currentValue);
    }

    private void valueChanged(Event event) {
        final Object oldValue = this.currentValue;
        final Object newValue = this.getValue();
        if (newValue == null) {
            return;
        }
        if (this.currentValue == null || !this.currentValue.equals(newValue)) {
            this.currentValue = newValue;
            if (event == null || (this.eventType & event.type) != 0) {
                this.fireValueChange(new ValueDiff(){

                    public Object getOldValue() {
                        return oldValue;
                    }

                    public Object getNewValue() {
                        return newValue;
                    }
                });
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 127 || e.keyCode == 8 || (e.stateMask & SWT.MOD1) != 0 && e.character == 'x') {
            this.valueChanged(null);
        }
    }
}

