/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.flow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTAllStopStmtNode;
import org.eclipse.photran.internal.core.parser.ASTArithmeticIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssociateConstructNode;
import org.eclipse.photran.internal.core.parser.ASTBlockConstructNode;
import org.eclipse.photran.internal.core.parser.ASTComputedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCriticalConstructNode;
import org.eclipse.photran.internal.core.parser.ASTCycleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseConstructNode;
import org.eclipse.photran.internal.core.parser.ASTElseIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTElseWhereConstructNode;
import org.eclipse.photran.internal.core.parser.ASTEndFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTExitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTForallConstructNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLblRefListNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTMaskedElseWhereConstructNode;
import org.eclipse.photran.internal.core.parser.ASTModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTReturnStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSelectTypeConstructNode;
import org.eclipse.photran.internal.core.parser.ASTStopStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTWhereConstructNode;
import org.eclipse.photran.internal.core.parser.ASTWhereStmtNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IObsoleteActionStmt;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

public class ControlFlowAnalysis
extends ASTVisitorWithLoops {
    private Set<IASTNode> predecessors = Collections.emptySet();
    private HashMap<String, IActionStmt> labels = new HashMap();
    private HashMap<String, String> assignedLabels = new HashMap();
    private HashMap<ASTProperLoopConstructNode, Set<ASTExitStmtNode>> exitsList = new HashMap();
    private Set<IASTNode> handled = new HashSet<IASTNode>(128);

    public static void analyze(String filename, ASTExecutableProgramNode ast) {
        final HashMap<String, IActionStmt> labels = new HashMap<String, IActionStmt>();
        final HashMap<String, String> assignedLabels = new HashMap<String, String>();
        final HashMap<ASTProperLoopConstructNode, Set<ASTExitStmtNode>> exitsList = new HashMap<ASTProperLoopConstructNode, Set<ASTExitStmtNode>>();
        ast.accept(new ASTVisitorWithLoops(){

            @Override
            public void visitASTAssignStmtNode(ASTAssignStmtNode node) {
                assignedLabels.put(node.getVariableName().getText(), node.getAssignedLblRef().getLabel().getText());
            }

            @Override
            public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
                exitsList.put(node, node.getExits());
                this.traverseChildren(node);
            }

            @Override
            public void visitIActionStmt(IActionStmt node) {
                if (node.getLabel() != null) {
                    labels.put(node.getLabel().getText(), node);
                }
            }
        });
        ast.accept(new ControlFlowAnalysis(filename, labels, assignedLabels, exitsList));
    }

    private ControlFlowAnalysis(String filename, HashMap<String, IActionStmt> labels, HashMap<String, String> assignedLabels, HashMap<ASTProperLoopConstructNode, Set<ASTExitStmtNode>> exitsList) {
        this.labels = labels;
        this.assignedLabels = assignedLabels;
        this.exitsList = exitsList;
        new PhotranTokenRef(filename, Integer.MAX_VALUE, 0);
    }

    private void createFlow(IASTNode pred, IASTNode toNode) {
        PhotranTokenRef from = pred.findFirstToken().getTokenRef();
        PhotranTokenRef to = toNode.findFirstToken().getTokenRef();
        PhotranVPG.getProvider().createFlow(from, to);
    }

    private void flowTo(IASTNode toNode) {
        for (IASTNode pred : this.predecessors) {
            this.createFlow(pred, toNode);
        }
        this.predecessors = Collections.singleton(toNode);
        this.handled.add(toNode);
    }

    private void flowToExit(IASTNode node) {
        this.flowTo(node);
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitIActionStmt(IActionStmt node) {
        if (!this.handled.contains(node)) {
            this.visitIExecutableConstruct(node);
        }
    }

    @Override
    public void visitIExecutableConstruct(IExecutableConstruct node) {
        if (!this.handled.contains(node)) {
            this.flowTo(node);
            this.handled.add(node);
        }
    }

    @Override
    public void visitIObsoleteActionStmt(IObsoleteActionStmt node) {
        if (!this.handled.contains(node)) {
            this.visitIActionStmt(node);
        }
    }

    @Override
    public void visitASTAllStopStmtNode(ASTAllStopStmtNode node) {
        this.flowTo(node);
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitASTArithmeticIfStmtNode(ASTArithmeticIfStmtNode node) {
        this.flowTo(node);
        String label = node.getFirst().getLabel().getText();
        IASTNode destination = this.labels.get(label);
        if (destination != null) {
            this.createFlow(node, destination);
        }
        if ((destination = (IASTNode)this.labels.get(label = node.getSecond().getLabel().getText())) != null) {
            this.createFlow(node, destination);
        }
        if ((destination = (IASTNode)this.labels.get(label = node.getThird().getLabel().getText())) != null) {
            this.createFlow(node, destination);
        }
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitASTAssignedGotoStmtNode(ASTAssignedGotoStmtNode node) {
        this.flowTo(node);
        String label = this.assignedLabels.get(node.getVariableName().getText());
        IASTNode destination = this.labels.get(label);
        if (destination != null) {
            this.createFlow(node, destination);
        }
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitASTAssociateConstructNode(ASTAssociateConstructNode node) {
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTBlockConstructNode(ASTBlockConstructNode node) {
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTComputedGotoStmtNode(ASTComputedGotoStmtNode node) {
        this.flowTo(node);
        for (ASTLblRefListNode lblnode : node.getLblRefList()) {
            String label = lblnode.getLabel().getText();
            IASTNode destination = this.labels.get(label);
            if (destination == null) continue;
            this.createFlow(node, destination);
        }
    }

    @Override
    public void visitASTCriticalConstructNode(ASTCriticalConstructNode node) {
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTCycleStmtNode(ASTCycleStmtNode node) {
        this.flowTo(node);
        this.createFlow(node, node.findNearestAncestor(ASTProperLoopConstructNode.class));
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitASTElseConstructNode(ASTElseConstructNode node) {
        this.flowTo(node);
        if (node.getConditionalBody() != null) {
            node.getConditionalBody().accept(this);
        }
    }

    @Override
    public void visitASTElseIfConstructNode(ASTElseIfConstructNode node) {
        this.flowTo(node);
        HashSet<IASTNode> oldpredecessors = new HashSet<IASTNode>();
        HashSet<IASTNode> conditionalpreds = new HashSet<IASTNode>();
        oldpredecessors.addAll(this.predecessors);
        node.getConditionalBody().accept(this);
        conditionalpreds.addAll(this.predecessors);
        this.predecessors = oldpredecessors;
        if (node.getElseIfConstruct() != null) {
            node.getElseIfConstruct().accept(this);
            conditionalpreds.addAll(this.predecessors);
        }
        if (node.getElseConstruct() != null) {
            node.getElseConstruct().accept(this);
            conditionalpreds.addAll(this.predecessors);
        }
        this.predecessors = conditionalpreds;
    }

    @Override
    public void visitASTElseWhereConstructNode(ASTElseWhereConstructNode node) {
        this.flowTo(node);
        node.getWhereBodyConstructBlock().accept(this);
    }

    @Override
    public void visitASTEndFunctionStmtNode(ASTEndFunctionStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTEndModuleStmtNode(ASTEndModuleStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTEndProgramStmtNode(ASTEndProgramStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTEndSubroutineStmtNode(ASTEndSubroutineStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTExitStmtNode(ASTExitStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTForallConstructNode(ASTForallConstructNode node) {
        this.flowTo(node);
        node.getForallBody().accept(this);
        this.flowTo(node);
    }

    @Override
    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        this.predecessors = Collections.emptySet();
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTGotoStmtNode(ASTGotoStmtNode node) {
        this.flowTo(node);
        String label = node.getGotoLblRef().getLabel().getText();
        IASTNode destination = this.labels.get(label);
        if (destination != null) {
            this.createFlow(node, destination);
        }
        this.predecessors = Collections.emptySet();
    }

    @Override
    public void visitASTIfConstructNode(ASTIfConstructNode node) {
        this.flowTo(node);
        HashSet<IASTNode> oldpredecessors = new HashSet<IASTNode>();
        HashSet<IASTNode> conditionalpreds = new HashSet<IASTNode>();
        oldpredecessors.addAll(this.predecessors);
        node.getConditionalBody().accept(this);
        conditionalpreds.addAll(this.predecessors);
        this.predecessors = oldpredecessors;
        if (node.getElseIfConstruct() != null) {
            node.getElseIfConstruct().accept(this);
            conditionalpreds.addAll(this.predecessors);
        }
        if (node.getElseConstruct() != null) {
            node.getElseConstruct().accept(this);
            conditionalpreds.addAll(this.predecessors);
        }
        this.predecessors = conditionalpreds;
    }

    @Override
    public void visitASTIfStmtNode(ASTIfStmtNode node) {
        this.flowTo(node);
        Set<IASTNode> predsBeforeStmt = this.predecessors;
        if (node.getActionStmt() != null) {
            node.getActionStmt().accept(this);
        }
        Set<IASTNode> predsAfterStmt = this.predecessors;
        HashSet<IASTNode> newPredecessors = new HashSet<IASTNode>();
        newPredecessors.addAll(predsBeforeStmt);
        newPredecessors.addAll(predsAfterStmt);
        this.predecessors = newPredecessors;
    }

    @Override
    public void visitASTMainProgramNode(ASTMainProgramNode node) {
        this.predecessors = Collections.emptySet();
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTMaskedElseWhereConstructNode(ASTMaskedElseWhereConstructNode node) {
        this.flowTo(node);
        HashSet<IASTNode> oldpredecessors = new HashSet<IASTNode>();
        HashSet<IASTNode> newpredecessors = new HashSet<IASTNode>();
        oldpredecessors.addAll(this.predecessors);
        node.getWhereBodyConstructBlock().accept(this);
        newpredecessors.addAll(this.predecessors);
        this.predecessors = oldpredecessors;
        if (node.getMaskedElseWhereConstruct() != null) {
            node.getMaskedElseWhereConstruct().accept(this);
            newpredecessors.addAll(this.predecessors);
        }
        if (node.getElseWhereConstruct() != null) {
            node.getElseWhereConstruct().accept(this);
            newpredecessors.addAll(this.predecessors);
        }
        this.predecessors = newpredecessors;
    }

    @Override
    public void visitASTModuleStmtNode(ASTModuleStmtNode node) {
        this.predecessors = Collections.emptySet();
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
        HashSet<IASTNode> newpredecessors = new HashSet<IASTNode>();
        this.flowTo(node);
        node.getBody().accept(this);
        this.flowTo(node);
        newpredecessors.addAll(this.predecessors);
        if (this.exitsList.get(node) != null) {
            for (ASTExitStmtNode exitnode : this.exitsList.get(node)) {
                if (!this.isPredecessor(node, exitnode)) continue;
                newpredecessors.add(exitnode);
            }
        }
        this.predecessors = newpredecessors;
    }

    protected boolean isPredecessor(ASTProperLoopConstructNode node, ASTExitStmtNode exitnode) {
        if (exitnode.getName() == null) {
            return true;
        }
        if (node.getLoopHeader().getName() == null) {
            return false;
        }
        return exitnode.getName().getText().equals(node.getLoopHeader().getName().getText());
    }

    @Override
    public void visitASTReturnStmtNode(ASTReturnStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTSelectTypeConstructNode(ASTSelectTypeConstructNode node) {
        HashSet<IASTNode> newpredecessors = new HashSet<IASTNode>();
        this.flowTo(node);
        Set<IASTNode> oldpredecessors = this.predecessors;
        for (IASTNode iASTNode : node.getSelectTypeBody()) {
            this.predecessors = oldpredecessors;
            iASTNode.accept(this);
            newpredecessors.addAll(this.predecessors);
        }
        this.predecessors = newpredecessors;
    }

    @Override
    public void visitASTStopStmtNode(ASTStopStmtNode node) {
        this.flowToExit(node);
    }

    @Override
    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        this.predecessors = Collections.emptySet();
        this.flowTo(node);
        this.traverseChildren(node);
    }

    @Override
    public void visitASTWhereConstructNode(ASTWhereConstructNode node) {
        this.flowTo(node);
        HashSet<IASTNode> oldpredecessors = new HashSet<IASTNode>();
        HashSet<IASTNode> newpredecessors = new HashSet<IASTNode>();
        oldpredecessors.addAll(this.predecessors);
        node.getWhereBodyConstructBlock().accept(this);
        newpredecessors.addAll(this.predecessors);
        this.predecessors = oldpredecessors;
        if (node.getMaskedElseWhereConstruct() != null) {
            node.getMaskedElseWhereConstruct().accept(this);
            newpredecessors.addAll(this.predecessors);
        }
        if (node.getElseWhereConstruct() != null) {
            node.getElseWhereConstruct().accept(this);
            newpredecessors.addAll(this.predecessors);
        }
        this.predecessors = newpredecessors;
    }

    @Override
    public void visitASTWhereStmtNode(ASTWhereStmtNode node) {
        this.flowTo(node);
        node.getAssignmentStmt().accept(this);
    }
}

